/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.codec.binary;

import cn.ujava.common.codec.Decoder;
import cn.ujava.common.codec.Encoder;
import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.text.StrUtil;

public class Base16Codec
implements Encoder<byte[], char[]>,
Decoder<CharSequence, byte[]> {
    public static final Base16Codec CODEC_LOWER = new Base16Codec(true);
    public static final Base16Codec CODEC_UPPER = new Base16Codec(false);
    private final char[] alphabets;

    public Base16Codec(boolean lowerCase) {
        this.alphabets = (lowerCase ? "0123456789abcdef" : "0123456789ABCDEF").toCharArray();
    }

    @Override
    public char[] encode(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = this.hexDigit(data[i] >> 4);
            out[j++] = this.hexDigit(data[i]);
        }
        return out;
    }

    @Override
    public byte[] decode(CharSequence encoded) {
        if (StrUtil.isEmpty(encoded)) {
            return null;
        }
        int len = (encoded = StrUtil.cleanBlank(encoded)).length();
        if ((len & 1) != 0) {
            encoded = "0" + encoded;
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Base16Codec.toDigit(encoded.charAt(j), j) << 4;
            f |= Base16Codec.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public String toUnicodeHex(char ch) {
        return "\\u" + this.hexDigit(ch >> 12) + this.hexDigit(ch >> 8) + this.hexDigit(ch >> 4) + this.hexDigit(ch);
    }

    public void appendHex(StringBuilder builder, byte b) {
        builder.append(this.hexDigit(b >> 4));
        builder.append(this.hexDigit(b));
    }

    public char hexDigit(int b) {
        return this.alphabets[b & 0xF];
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new HutoolException("Illegal hexadecimal character {} at index {}", Character.valueOf(ch), index);
        }
        return digit;
    }
}

