/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.codec.binary;

import cn.ujava.common.codec.binary.Base62Codec;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.ByteUtil;
import cn.ujava.common.util.CharsetUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Base62 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    public static String encode(CharSequence source) {
        return Base62.encode(source, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base62.encode(ByteUtil.toBytes(source, charset));
    }

    public static String encode(byte[] source) {
        return new String(Base62Codec.INSTANCE.encode(source));
    }

    public static String encode(InputStream in) {
        return Base62.encode(IoUtil.readBytes(in));
    }

    public static String encode(File file) {
        return Base62.encode(FileUtil.readBytes(file));
    }

    public static String encodeInverted(CharSequence source) {
        return Base62.encodeInverted(source, DEFAULT_CHARSET);
    }

    public static String encodeInverted(CharSequence source, Charset charset) {
        return Base62.encodeInverted(ByteUtil.toBytes(source, charset));
    }

    public static String encodeInverted(byte[] source) {
        return new String(Base62Codec.INSTANCE.encode(source, true));
    }

    public static String encodeInverted(InputStream in) {
        return Base62.encodeInverted(IoUtil.readBytes(in));
    }

    public static String encodeInverted(File file) {
        return Base62.encodeInverted(FileUtil.readBytes(file));
    }

    public static String decodeStrGbk(CharSequence source) {
        return Base62.decodeStr(source, CharsetUtil.GBK);
    }

    public static String decodeStr(CharSequence source) {
        return Base62.decodeStr(source, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source, Charset charset) {
        return StrUtil.str(Base62.decode(source), charset);
    }

    public static File decodeToFile(CharSequence Base622, File destFile) {
        return FileUtil.writeBytes(Base62.decode(Base622), destFile);
    }

    public static void decodeToStream(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoUtil.write(out, isCloseOut, Base62.decode(base62Str));
    }

    public static byte[] decode(CharSequence base62Str) {
        return Base62.decode(ByteUtil.toBytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] base62bytes) {
        return Base62Codec.INSTANCE.decode(base62bytes);
    }

    public static String decodeStrInverted(CharSequence source) {
        return Base62.decodeStrInverted(source, DEFAULT_CHARSET);
    }

    public static String decodeStrInverted(CharSequence source, Charset charset) {
        return StrUtil.str(Base62.decodeInverted(source), charset);
    }

    public static File decodeToFileInverted(CharSequence Base622, File destFile) {
        return FileUtil.writeBytes(Base62.decodeInverted(Base622), destFile);
    }

    public static void decodeToStreamInverted(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoUtil.write(out, isCloseOut, Base62.decodeInverted(base62Str));
    }

    public static byte[] decodeInverted(CharSequence base62Str) {
        return Base62.decodeInverted(ByteUtil.toBytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decodeInverted(byte[] base62bytes) {
        return Base62Codec.INSTANCE.decode(base62bytes, true);
    }
}

