/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.comparator;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.comparator.IndexedComparator;
import cn.ujava.common.comparator.PinyinComparator;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

public class CompareUtil {
    public static int compare(char x, char y) {
        return Character.compare(x, y);
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public static <E extends Comparable<? super E>> Comparator<E> natural() {
        return Comparator.naturalOrder();
    }

    public static <E extends Comparable<? super E>> Comparator<E> naturalReverse() {
        return Comparator.reverseOrder();
    }

    public static <E extends Comparable<? super E>> Comparator<E> reverse(Comparator<E> comparator) {
        return null == comparator ? CompareUtil.naturalReverse() : comparator.reversed();
    }

    public static <T> int compare(T c1, T c2, Comparator<T> comparator) {
        if (null == comparator) {
            return CompareUtil.compare((Comparable)c1, (Comparable)c2);
        }
        return comparator.compare(c1, c2);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return CompareUtil.compare(c1, c2, false);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return isNullGreater ? 1 : -1;
        }
        if (c2 == null) {
            return isNullGreater ? -1 : 1;
        }
        return c1.compareTo(c2);
    }

    public static <T> int compare(T o1, T o2, boolean isNullGreater) {
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return isNullGreater ? -1 : 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Integer.compare(o1.hashCode(), o2.hashCode());
        if (0 == result) {
            result = CompareUtil.compare(o1.toString(), o2.toString());
        }
        return result;
    }

    public static <T> Comparator<T> comparingPinyin(Function<T, String> keyExtractor) {
        return CompareUtil.comparingPinyin(keyExtractor, false);
    }

    public static <T> Comparator<T> comparingPinyin(Function<T, String> keyExtractor, boolean reverse) {
        Objects.requireNonNull(keyExtractor);
        PinyinComparator pinyinComparator = new PinyinComparator();
        if (reverse) {
            return (o1, o2) -> pinyinComparator.compare(keyExtractor.apply(o2), keyExtractor.apply(o1));
        }
        return (o1, o2) -> pinyinComparator.compare(keyExtractor.apply(o1), keyExtractor.apply(o2));
    }

    public static <T, U> Comparator<T> comparingIndexed(Function<? super T, ? extends U> keyExtractor, U[] objs) {
        return CompareUtil.comparingIndexed(keyExtractor, false, objs);
    }

    public static <T, U> Comparator<T> comparingIndexed(Function<? super T, ? extends U> keyExtractor, Iterable<U> objs) {
        return CompareUtil.comparingIndexed(keyExtractor, false, ArrayUtil.ofArray(objs, objs.iterator().next().getClass()));
    }

    public static <T, U> Comparator<T> comparingIndexed(Function<? super T, ? extends U> keyExtractor, boolean atEndIfMiss, U ... objs) {
        Objects.requireNonNull(keyExtractor);
        IndexedComparator indexedComparator = new IndexedComparator(atEndIfMiss, objs);
        return (o1, o2) -> indexedComparator.compare(keyExtractor.apply(o1), keyExtractor.apply(o2));
    }

    public static <T extends Comparable<? super T>> T min(T t1, T t2) {
        return CompareUtil.compare(t1, t2) <= 0 ? t1 : t2;
    }

    public static <T extends Comparable<? super T>> T max(T t1, T t2) {
        return CompareUtil.compare(t1, t2) >= 0 ? t1 : t2;
    }

    public static <T extends Comparable<? super T>> boolean equals(T c1, T c2) {
        return CompareUtil.compare(c1, c2) == 0;
    }

    public static <T extends Comparable<? super T>> boolean gt(T c1, T c2) {
        return CompareUtil.compare(c1, c2) > 0;
    }

    public static <T extends Comparable<? super T>> boolean ge(T c1, T c2) {
        return CompareUtil.compare(c1, c2) >= 0;
    }

    public static <T extends Comparable<? super T>> boolean lt(T c1, T c2) {
        return CompareUtil.compare(c1, c2) < 0;
    }

    public static <T extends Comparable<? super T>> boolean le(T c1, T c2) {
        return CompareUtil.compare(c1, c2) <= 0;
    }

    public static <T extends Comparable<? super T>> boolean isIn(T value, T c1, T c2) {
        return CompareUtil.ge(value, CompareUtil.min(c1, c2)) && CompareUtil.le(value, CompareUtil.max(c1, c2));
    }

    public static <T extends Comparable<? super T>> boolean isInExclusive(T value, T c1, T c2) {
        return CompareUtil.gt(value, CompareUtil.min(c1, c2)) && CompareUtil.lt(value, CompareUtil.max(c1, c2));
    }
}

