/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.compress;

import cn.ujava.common.compress.ZipResource;
import cn.ujava.common.compress.ZipSecurityUtil;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipStreamResource
implements ZipResource {
    private final ZipInputStream in;

    public ZipStreamResource(ZipInputStream in) {
        this.in = in;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
                ZipSecurityUtil.checkZipBomb(zipEntry, maxSizeDiff);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public InputStream get(String path) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                if (!zipEntry.getName().equals(path)) continue;
                return this.in;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(this.in);
    }
}

