/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.convert.AbstractConverter;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.DateUtil;
import cn.ujava.common.date.SqlDateUtil;
import cn.ujava.common.text.StrUtil;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StrUtil.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateUtil.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateUtil.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToStr(value);
        DateTime dateTime2 = dateTime = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(targetClass, dateTime);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, DateTime date) {
        if (Date.class == targetClass) {
            return date.toJdkDate();
        }
        if (DateTime.class == targetClass) {
            return date;
        }
        return this.wrap(targetClass, date.getTime());
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateUtil.date(mills);
        }
        return SqlDateUtil.wrap(targetClass, mills);
    }
}

