/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.convert.AbstractConverter;
import cn.ujava.common.convert.Convert;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.impl.NumberConverter;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.ObjUtil;
import java.util.function.Function;

public class PrimitiveConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveConverter INSTANCE = new PrimitiveConverter();

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        return PrimitiveConverter.convert(value, targetClass, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value) {
        return StrUtil.trim(super.convertToStr(value));
    }

    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        if (Byte.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return ObjUtil.defaultIfNull(NumberConverter.convert(value, Double.class, toStringFunc), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            return Convert.convert(Boolean.class, value);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }
}

