/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl.stringer;

import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.impl.stringer.ClobStringer;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.util.CharsetUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.Function;

public class BlobStringer
implements Function<Object, String> {
    public static ClobStringer INSTANCE = new ClobStringer();

    @Override
    public String apply(Object o) {
        return BlobStringer.blobToStr((Blob)o);
    }

    private static String blobToStr(Blob blob) {
        String string;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            string = IoUtil.read(in, CharsetUtil.UTF_8);
        }
        catch (SQLException e) {
            try {
                throw new ConvertException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(in);
        return string;
    }
}

