/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl.stringer;

import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.io.IoUtil;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.function.Function;

public class ClobStringer
implements Function<Object, String> {
    public static ClobStringer INSTANCE = new ClobStringer();

    @Override
    public String apply(Object o) {
        return ClobStringer.clobToStr((Clob)o);
    }

    private static String clobToStr(Clob clob) {
        String string;
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            string = IoUtil.read(reader);
        }
        catch (SQLException e) {
            try {
                throw new ConvertException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(reader);
        return string;
    }
}

