/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.date;

import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.DateUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.text.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class SqlDateUtil {
    public static Timestamp timestamp(Date date) {
        Assert.notNull(date);
        return new Timestamp(date.getTime());
    }

    public static java.sql.Date date(Date date) {
        Assert.notNull(date);
        return new java.sql.Date(date.getTime());
    }

    public static Time time(Date date) {
        Assert.notNull(date);
        return new Time(date.getTime());
    }

    public static <T extends Date> T wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return (T)new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return (T)DateUtil.date(mills);
        }
        if (java.sql.Date.class == targetClass) {
            return (T)new java.sql.Date(mills);
        }
        if (Time.class == targetClass) {
            return (T)new Time(mills);
        }
        if (Timestamp.class == targetClass) {
            return (T)new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", targetClass.getName()));
    }
}

