/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.date.format.parser;

import cn.ujava.common.date.DateException;
import cn.ujava.common.date.DatePattern;
import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.format.DefaultDateBasic;
import cn.ujava.common.date.format.parser.DateParser;
import cn.ujava.common.text.StrUtil;

public class NormalDateParser
extends DefaultDateBasic
implements DateParser {
    private static final long serialVersionUID = 1L;
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public DateTime parse(String source) {
        int colonCount = StrUtil.count((CharSequence)source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = StrUtil.indexOf(source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = StrUtil.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", source);
    }
}

