/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.func;

import cn.ujava.common.exception.ExceptionUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

@FunctionalInterface
public interface SerBiConsumer<T, U>
extends BiConsumer<T, U>,
Serializable {
    @SafeVarargs
    public static <T, U> SerBiConsumer<T, U> multi(SerBiConsumer<T, U> ... consumers) {
        return Stream.of(consumers).reduce(SerBiConsumer::andThen).orElseGet(() -> (o, q) -> {});
    }

    public void accepting(T var1, U var2) throws Exception;

    @Override
    default public void accept(T t, U u) {
        try {
            this.accepting(t, u);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    @Override
    default public SerBiConsumer<T, U> andThen(SerBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accepting(l, r);
            after.accepting(l, r);
        };
    }

    public static <T, U> SerBiConsumer<T, U> nothing() {
        return (l, r) -> {};
    }
}

