/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.copy;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.copy.IoCopier;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileChannelCopier
extends IoCopier<FileChannel, FileChannel> {
    public static FileChannelCopier of() {
        return FileChannelCopier.of(-1L);
    }

    public static FileChannelCopier of(long count) {
        return new FileChannelCopier(count);
    }

    public FileChannelCopier(long count) {
        super(-1, count, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        long l;
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = this.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(outChannel);
            IoUtil.closeQuietly(inChannel);
            throw throwable;
        }
        IoUtil.closeQuietly(outChannel);
        IoUtil.closeQuietly(inChannel);
        return l;
    }

    @Override
    public long copy(FileChannel source, FileChannel target) {
        try {
            return this.doCopySafely(source, target);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private long doCopySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        if (this.count > 0L && this.count < totalBytes) {
            totalBytes = this.count;
        }
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }
}

