/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.util.CharsetUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public enum FileMagicNumber {
    UNKNOWN(null, null){

        @Override
        public boolean match(byte[] bytes) {
            return false;
        }
    }
    ,
    JPEG("image/jpeg", "jpg"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-40) && Objects.equals(bytes[2], (byte)-1);
        }
    }
    ,
    JXR("image/vnd.ms-photo", "jxr"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)73) && Objects.equals(bytes[2], (byte)-68);
        }
    }
    ,
    APNG("image/apng", "apng"){

        @Override
        public boolean match(byte[] bytes) {
            boolean b = ArrayUtil.startWith(bytes, -119, 80, 78, 71, 13, 10, 26, 10);
            if (b) {
                int dataLength;
                for (int i = 8; i < bytes.length; i += dataLength + 4) {
                    try {
                        dataLength = new BigInteger(1, Arrays.copyOfRange(bytes, i, i + 4)).intValue();
                        String chunkType = new String(bytes, i += 4, 4, CharsetUtil.ISO_8859_1);
                        i += 4;
                        if (Objects.equals(chunkType, "IDAT") || Objects.equals(chunkType, "IEND")) {
                            return false;
                        }
                        if (!Objects.equals(chunkType, "acTL")) continue;
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }
    }
    ,
    PNG("image/png", "png"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, -119, 80, 78, 71);
        }
    }
    ,
    GIF("image/gif", "gif"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 71, 73, 70);
        }
    }
    ,
    BMP("image/bmp", "bmp"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 66, 77);
        }
    }
    ,
    TIFF("image/tiff", "tiff"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 73, 73, 42, 0) || ArrayUtil.startWith(bytes, 77, 77, 0, 42);
        }
    }
    ,
    DWG("image/vnd.dwg", "dwg"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 65, 67, 49, 48);
        }
    }
    ,
    WEBP("image/webp", "webp"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.isSubEquals(bytes, 8, 87, 69, 66, 80);
        }
    }
    ,
    PSD("image/vnd.adobe.photoshop", "psd"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 56, 66, 80, 83);
        }
    }
    ,
    ICO("image/x-icon", "ico"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 0, 0, 1, 0);
        }
    }
    ,
    XCF("image/x-xcf", "xcf"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 103, 105, 109, 112, 32, 120, 99, 102, 32, 118);
        }
    }
    ,
    WAV("audio/x-wav", "wav"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 82, 73, 70, 70) && ArrayUtil.isSubEquals(bytes, 8, 87, 65, 86, 69);
        }
    }
    ,
    MIDI("audio/midi", "midi"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 77, 84, 104, 100);
        }
    }
    ,
    MP3("audio/mpeg", "mp3"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 73, 68, 51) || ArrayUtil.startWith(bytes, -1, -5) || ArrayUtil.startWith(bytes, -1, -13) || ArrayUtil.startWith(bytes, -1, -14);
        }
    }
    ,
    OGG("audio/ogg", "ogg"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 79, 103, 103, 83);
        }
    }
    ,
    FLAC("audio/x-flac", "flac"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 102, 76, 97, 67);
        }
    }
    ,
    M4A("audio/mp4", "m4a"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 10 && Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)52) && Objects.equals(bytes[10], (byte)65) || Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)52) && Objects.equals(bytes[2], (byte)65) && Objects.equals(bytes[3], (byte)32);
        }
    }
    ,
    AAC("audio/aac", "aac"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 1) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-15);
            boolean flag2 = Objects.equals(bytes[0], (byte)-1) && Objects.equals(bytes[1], (byte)-7);
            return flag1 || flag2;
        }
    }
    ,
    AMR("audio/amr", "amr"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 35, 33, 65, 77, 82, 10) || ArrayUtil.startWith(bytes, 35, 33, 65, 77, 82, 95, 77, 67, 49, 46, 48, 10);
        }
    }
    ,
    AC3("audio/ac3", "ac3"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 11, 119);
        }
    }
    ,
    AIFF("audio/x-aiff", "aiff"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 11 && Objects.equals(bytes[0], (byte)70) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)82) && Objects.equals(bytes[3], (byte)77) && Objects.equals(bytes[8], (byte)65) && Objects.equals(bytes[9], (byte)73) && Objects.equals(bytes[10], (byte)70) && Objects.equals(bytes[11], (byte)70);
        }
    }
    ,
    WOFF("font/woff", "woff"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 8) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)119) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)70);
            boolean flag2 = Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)1) && Objects.equals(bytes[6], (byte)0) && Objects.equals(bytes[7], (byte)0);
            boolean flag3 = Objects.equals(bytes[4], (byte)79) && Objects.equals(bytes[5], (byte)84) && Objects.equals(bytes[6], (byte)84) && Objects.equals(bytes[7], (byte)79);
            boolean flag4 = Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)117) && Objects.equals(bytes[7], (byte)101);
            return flag1 && (flag2 || flag3 || flag4);
        }
    }
    ,
    WOFF2("font/woff2", "woff2"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 8) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)119) && Objects.equals(bytes[1], (byte)79) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)50);
            boolean flag2 = Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)1) && Objects.equals(bytes[6], (byte)0) && Objects.equals(bytes[7], (byte)0);
            boolean flag3 = Objects.equals(bytes[4], (byte)79) && Objects.equals(bytes[5], (byte)84) && Objects.equals(bytes[6], (byte)84) && Objects.equals(bytes[7], (byte)79);
            boolean flag4 = Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)117) && Objects.equals(bytes[7], (byte)101);
            return flag1 && (flag2 || flag3 || flag4);
        }
    }
    ,
    TTF("font/ttf", "ttf"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)1) && Objects.equals(bytes[2], (byte)0) && Objects.equals(bytes[3], (byte)0) && Objects.equals(bytes[4], (byte)0);
        }
    }
    ,
    OTF("font/otf", "otf"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)79) && Objects.equals(bytes[1], (byte)84) && Objects.equals(bytes[2], (byte)84) && Objects.equals(bytes[3], (byte)79) && Objects.equals(bytes[4], (byte)0);
        }
    }
    ,
    EPUB("application/epub+zip", "epub"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 58 && Objects.equals(bytes[0], (byte)80) && Objects.equals(bytes[1], (byte)75) && Objects.equals(bytes[2], (byte)3) && Objects.equals(bytes[3], (byte)4) && Objects.equals(bytes[30], (byte)109) && Objects.equals(bytes[31], (byte)105) && Objects.equals(bytes[32], (byte)109) && Objects.equals(bytes[33], (byte)101) && Objects.equals(bytes[34], (byte)116) && Objects.equals(bytes[35], (byte)121) && Objects.equals(bytes[36], (byte)112) && Objects.equals(bytes[37], (byte)101) && Objects.equals(bytes[38], (byte)97) && Objects.equals(bytes[39], (byte)112) && Objects.equals(bytes[40], (byte)112) && Objects.equals(bytes[41], (byte)108) && Objects.equals(bytes[42], (byte)105) && Objects.equals(bytes[43], (byte)99) && Objects.equals(bytes[44], (byte)97) && Objects.equals(bytes[45], (byte)116) && Objects.equals(bytes[46], (byte)105) && Objects.equals(bytes[47], (byte)111) && Objects.equals(bytes[48], (byte)110) && Objects.equals(bytes[49], (byte)47) && Objects.equals(bytes[50], (byte)101) && Objects.equals(bytes[51], (byte)112) && Objects.equals(bytes[52], (byte)117) && Objects.equals(bytes[53], (byte)98) && Objects.equals(bytes[54], (byte)43) && Objects.equals(bytes[55], (byte)122) && Objects.equals(bytes[56], (byte)105) && Objects.equals(bytes[57], (byte)112);
        }
    }
    ,
    ZIP("application/zip", "zip"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 4) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)80) && Objects.equals(bytes[1], (byte)75);
            boolean flag2 = Objects.equals(bytes[2], (byte)3) || Objects.equals(bytes[2], (byte)5) || Objects.equals(bytes[2], (byte)7);
            boolean flag3 = Objects.equals(bytes[3], (byte)4) || Objects.equals(bytes[3], (byte)6) || Objects.equals(bytes[3], (byte)8);
            return flag1 && flag2 && flag3;
        }
    }
    ,
    TAR("application/x-tar", "tar"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 261 && Objects.equals(bytes[257], (byte)117) && Objects.equals(bytes[258], (byte)115) && Objects.equals(bytes[259], (byte)116) && Objects.equals(bytes[260], (byte)97) && Objects.equals(bytes[261], (byte)114);
        }
    }
    ,
    RAR("application/x-rar-compressed", "rar"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)82) && Objects.equals(bytes[1], (byte)97) && Objects.equals(bytes[2], (byte)114) && Objects.equals(bytes[3], (byte)33) && Objects.equals(bytes[4], (byte)26) && Objects.equals(bytes[5], (byte)7) && (Objects.equals(bytes[6], (byte)0) || Objects.equals(bytes[6], (byte)1));
        }
    }
    ,
    GZ("application/gzip", "gz"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)31) && Objects.equals(bytes[1], (byte)-117) && Objects.equals(bytes[2], (byte)8);
        }
    }
    ,
    BZ2("application/x-bzip2", "bz2"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 2 && Objects.equals(bytes[0], (byte)66) && Objects.equals(bytes[1], (byte)90) && Objects.equals(bytes[2], (byte)104);
        }
    }
    ,
    SevenZ("application/x-7z-compressed", "7z"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)55) && Objects.equals(bytes[1], (byte)122) && Objects.equals(bytes[2], (byte)-68) && Objects.equals(bytes[3], (byte)-81) && Objects.equals(bytes[4], (byte)39) && Objects.equals(bytes[5], (byte)28) && Objects.equals(bytes[6], (byte)0);
        }
    }
    ,
    PDF("application/pdf", "pdf"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length > 3 && Objects.equals(bytes[0], (byte)-17) && Objects.equals(bytes[1], (byte)-69) && Objects.equals(bytes[2], (byte)-65)) {
                bytes = Arrays.copyOfRange(bytes, 3, bytes.length);
            }
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)37) && Objects.equals(bytes[1], (byte)80) && Objects.equals(bytes[2], (byte)68) && Objects.equals(bytes[3], (byte)70);
        }
    }
    ,
    EXE("application/x-msdownload", "exe"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 1 && Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)90);
        }
    }
    ,
    SWF("application/x-shockwave-flash", "swf"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 2 && (Objects.equals(bytes[0], 67) || Objects.equals(bytes[0], (byte)70)) && Objects.equals(bytes[1], (byte)87) && Objects.equals(bytes[2], (byte)83);
        }
    }
    ,
    RTF("application/rtf", "rtf"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)123) && Objects.equals(bytes[1], (byte)92) && Objects.equals(bytes[2], (byte)114) && Objects.equals(bytes[3], (byte)116) && Objects.equals(bytes[4], (byte)102);
        }
    }
    ,
    NES("application/x-nintendo-nes-rom", "nes"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)78) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)83) && Objects.equals(bytes[3], (byte)26);
        }
    }
    ,
    CRX("application/x-google-chrome-extension", "crx"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)67) && Objects.equals(bytes[1], (byte)114) && Objects.equals(bytes[2], (byte)50) && Objects.equals(bytes[3], (byte)52);
        }
    }
    ,
    CAB("application/vnd.ms-cab-compressed", "cab"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 4) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[0], (byte)77) && Objects.equals(bytes[1], (byte)83) && Objects.equals(bytes[2], (byte)67) && Objects.equals(bytes[3], (byte)70);
            boolean flag2 = Objects.equals(bytes[0], (byte)73) && Objects.equals(bytes[1], (byte)83) && Objects.equals(bytes[2], (byte)99) && Objects.equals(bytes[3], (byte)40);
            return flag1 || flag2;
        }
    }
    ,
    PS("application/postscript", "ps"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 1 && Objects.equals(bytes[0], (byte)37) && Objects.equals(bytes[1], (byte)33);
        }
    }
    ,
    XZ("application/x-xz", "xz"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 5 && Objects.equals(bytes[0], (byte)-3) && Objects.equals(bytes[1], (byte)55) && Objects.equals(bytes[2], (byte)122) && Objects.equals(bytes[3], (byte)88) && Objects.equals(bytes[4], (byte)90) && Objects.equals(bytes[5], (byte)0);
        }
    }
    ,
    SQLITE("application/x-sqlite3", "sqlite"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 15 && Objects.equals(bytes[0], (byte)83) && Objects.equals(bytes[1], (byte)81) && Objects.equals(bytes[2], (byte)76) && Objects.equals(bytes[3], (byte)105) && Objects.equals(bytes[4], (byte)116) && Objects.equals(bytes[5], (byte)101) && Objects.equals(bytes[6], (byte)32) && Objects.equals(bytes[7], (byte)102) && Objects.equals(bytes[8], (byte)111) && Objects.equals(bytes[9], (byte)114) && Objects.equals(bytes[10], (byte)109) && Objects.equals(bytes[11], (byte)97) && Objects.equals(bytes[12], (byte)116) && Objects.equals(bytes[13], (byte)32) && Objects.equals(bytes[14], (byte)51) && Objects.equals(bytes[15], (byte)0);
        }
    }
    ,
    DEB("application/x-deb", "deb"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 20 && Objects.equals(bytes[0], (byte)33) && Objects.equals(bytes[1], (byte)60) && Objects.equals(bytes[2], (byte)97) && Objects.equals(bytes[3], (byte)114) && Objects.equals(bytes[4], (byte)99) && Objects.equals(bytes[5], (byte)104) && Objects.equals(bytes[6], (byte)62) && Objects.equals(bytes[7], (byte)10) && Objects.equals(bytes[8], (byte)100) && Objects.equals(bytes[9], (byte)101) && Objects.equals(bytes[10], (byte)98) && Objects.equals(bytes[11], (byte)105) && Objects.equals(bytes[12], (byte)97) && Objects.equals(bytes[13], (byte)110) && Objects.equals(bytes[14], (byte)45) && Objects.equals(bytes[15], (byte)98) && Objects.equals(bytes[16], (byte)105) && Objects.equals(bytes[17], (byte)110) && Objects.equals(bytes[18], (byte)97) && Objects.equals(bytes[19], (byte)114) && Objects.equals(bytes[20], (byte)121);
        }
    }
    ,
    AR("application/x-unix-archive", "ar"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 6 && Objects.equals(bytes[0], (byte)33) && Objects.equals(bytes[1], (byte)60) && Objects.equals(bytes[2], (byte)97) && Objects.equals(bytes[3], (byte)114) && Objects.equals(bytes[4], (byte)99) && Objects.equals(bytes[5], (byte)104) && Objects.equals(bytes[6], (byte)62);
        }
    }
    ,
    LZOP("application/x-lzop", "lzo"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 7 && Objects.equals(bytes[0], (byte)-119) && Objects.equals(bytes[1], (byte)76) && Objects.equals(bytes[2], (byte)90) && Objects.equals(bytes[3], (byte)79) && Objects.equals(bytes[4], (byte)0) && Objects.equals(bytes[5], (byte)13) && Objects.equals(bytes[6], (byte)10) && Objects.equals(bytes[7], (byte)26);
        }
    }
    ,
    LZ("application/x-lzip", "lz"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)76) && Objects.equals(bytes[1], (byte)90) && Objects.equals(bytes[2], (byte)73) && Objects.equals(bytes[3], (byte)80);
        }
    }
    ,
    ELF("application/x-executable", "elf"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 52 && Objects.equals(bytes[0], (byte)127) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)76) && Objects.equals(bytes[3], (byte)70);
        }
    }
    ,
    LZ4("application/x-lz4", "lz4"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)4) && Objects.equals(bytes[1], (byte)34) && Objects.equals(bytes[2], (byte)77) && Objects.equals(bytes[3], (byte)24);
        }
    }
    ,
    BR("application/x-brotli", "br"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)-50) && Objects.equals(bytes[1], (byte)-78) && Objects.equals(bytes[2], (byte)-49) && Objects.equals(bytes[3], (byte)-127);
        }
    }
    ,
    DCM("application/x-dicom", "dcm"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 128 && Objects.equals(bytes[128], (byte)68) && Objects.equals(bytes[129], (byte)73) && Objects.equals(bytes[130], (byte)67) && Objects.equals(bytes[131], (byte)77);
        }
    }
    ,
    RPM("application/x-rpm", "rpm"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)-19) && Objects.equals(bytes[1], (byte)-85) && Objects.equals(bytes[2], (byte)-18) && Objects.equals(bytes[3], (byte)-37);
        }
    }
    ,
    ZSTD("application/x-zstd", "zst"){

        @Override
        public boolean match(byte[] bytes) {
            boolean flag1;
            int length = bytes.length;
            if (length < 5) {
                return false;
            }
            byte[] buf1 = new byte[]{34, 35, 36, 37, 38, 39, 40};
            boolean bl = flag1 = ArrayUtil.contains(buf1, bytes[0]) && Objects.equals(bytes[1], (byte)-75) && Objects.equals(bytes[2], (byte)47) && Objects.equals(bytes[3], (byte)-3);
            if (flag1) {
                return true;
            }
            if ((bytes[0] & 0xF0) == 80) {
                return bytes[1] == 42 && bytes[2] == 77 && bytes[3] == 24;
            }
            return false;
        }
    }
    ,
    MP4("video/mp4", "mp4"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 13) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)83) && Objects.equals(bytes[10], (byte)78) && Objects.equals(bytes[11], (byte)86);
            boolean flag2 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)105) && Objects.equals(bytes[9], (byte)115) && Objects.equals(bytes[10], (byte)111) && Objects.equals(bytes[11], (byte)109);
            return flag1 || flag2;
        }
    }
    ,
    AVI("video/x-msvideo", "avi"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 11 && Objects.equals(bytes[0], (byte)82) && Objects.equals(bytes[1], (byte)73) && Objects.equals(bytes[2], (byte)70) && Objects.equals(bytes[3], (byte)70) && Objects.equals(bytes[8], (byte)65) && Objects.equals(bytes[9], (byte)86) && Objects.equals(bytes[10], (byte)73) && Objects.equals(bytes[11], (byte)32);
        }
    }
    ,
    WMV("video/x-ms-wmv", "wmv"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 9 && Objects.equals(bytes[0], (byte)48) && Objects.equals(bytes[1], (byte)38) && Objects.equals(bytes[2], (byte)-78) && Objects.equals(bytes[3], (byte)117) && Objects.equals(bytes[4], (byte)-114) && Objects.equals(bytes[5], (byte)102) && Objects.equals(bytes[6], (byte)-49) && Objects.equals(bytes[7], (byte)17) && Objects.equals(bytes[8], (byte)-90) && Objects.equals(bytes[9], (byte)-39);
        }
    }
    ,
    M4V("video/x-m4v", "m4v"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 12) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)77) && Objects.equals(bytes[9], (byte)52) && Objects.equals(bytes[10], (byte)86) && Objects.equals(bytes[11], (byte)32);
            boolean flag2 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)109) && Objects.equals(bytes[9], (byte)112) && Objects.equals(bytes[10], (byte)52) && Objects.equals(bytes[11], (byte)50);
            return flag1 || flag2;
        }
    }
    ,
    FLV("video/x-flv", "flv"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)70) && Objects.equals(bytes[1], (byte)76) && Objects.equals(bytes[2], (byte)86) && Objects.equals(bytes[3], (byte)1);
        }
    }
    ,
    MKV("video/x-matroska", "mkv"){

        @Override
        public boolean match(byte[] bytes) {
            boolean flag1;
            boolean bl = flag1 = bytes.length > 11 && Objects.equals(bytes[0], (byte)26) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)-33) && Objects.equals(bytes[3], (byte)-93);
            if (flag1) {
                byte[] bytes1 = new byte[]{66, -126, -120, 109, 97, 116, 114, 111, 115, 107, 97};
                int index = FileMagicNumber.indexOf(bytes, bytes1);
                return index > 0;
            }
            return false;
        }
    }
    ,
    WEBM("video/webm", "webm"){

        @Override
        public boolean match(byte[] bytes) {
            boolean flag1;
            boolean bl = flag1 = bytes.length > 8 && Objects.equals(bytes[0], (byte)26) && Objects.equals(bytes[1], (byte)69) && Objects.equals(bytes[2], (byte)-33) && Objects.equals(bytes[3], (byte)-93);
            if (flag1) {
                byte[] bytes1 = new byte[]{66, -126, -120, 119, 101, 98, 109};
                int index = FileMagicNumber.indexOf(bytes, bytes1);
                return index > 0;
            }
            return false;
        }
    }
    ,
    MOV("video/quicktime", "mov"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 12) {
                return false;
            }
            boolean flag1 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)113) && Objects.equals(bytes[9], (byte)116) && Objects.equals(bytes[10], (byte)32) && Objects.equals(bytes[11], (byte)32);
            boolean flag2 = Objects.equals(bytes[4], (byte)109) && Objects.equals(bytes[5], (byte)111) && Objects.equals(bytes[6], (byte)111) && Objects.equals(bytes[7], (byte)118);
            boolean flag3 = Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)114) && Objects.equals(bytes[6], (byte)101) && Objects.equals(bytes[7], (byte)101);
            boolean flag4 = Objects.equals(bytes[4], (byte)109) && Objects.equals(bytes[5], (byte)100) && Objects.equals(bytes[6], (byte)97) && Objects.equals(bytes[7], (byte)116);
            boolean flag5 = Objects.equals(bytes[4], (byte)119) && Objects.equals(bytes[5], (byte)105) && Objects.equals(bytes[6], (byte)100) && Objects.equals(bytes[7], (byte)101);
            boolean flag6 = Objects.equals(bytes[4], (byte)112) && Objects.equals(bytes[5], (byte)110) && Objects.equals(bytes[6], (byte)111) && Objects.equals(bytes[7], (byte)116);
            boolean flag7 = Objects.equals(bytes[4], (byte)115) && Objects.equals(bytes[5], (byte)107) && Objects.equals(bytes[6], (byte)105) && Objects.equals(bytes[7], (byte)112);
            return flag1 || flag2 || flag3 || flag4 || flag5 || flag6 || flag7;
        }
    }
    ,
    MPEG("video/mpeg", "mpg"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 3 && Objects.equals(bytes[0], (byte)0) && Objects.equals(bytes[1], (byte)0) && Objects.equals(bytes[2], (byte)1) && bytes[3] >= -80 && bytes[3] <= -65;
        }
    }
    ,
    RMVB("video/vnd.rn-realvideo", "rmvb"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 4 && Objects.equals(bytes[0], (byte)46) && Objects.equals(bytes[1], (byte)82) && Objects.equals(bytes[2], (byte)77) && Objects.equals(bytes[3], (byte)70);
        }
    }
    ,
    M3GP("video/3gpp", "3gp"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 10 && Objects.equals(bytes[4], (byte)102) && Objects.equals(bytes[5], (byte)116) && Objects.equals(bytes[6], (byte)121) && Objects.equals(bytes[7], (byte)112) && Objects.equals(bytes[8], (byte)51) && Objects.equals(bytes[9], (byte)103) && Objects.equals(bytes[10], (byte)112);
        }
    }
    ,
    DOC("application/msword", "doc"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            if (bytes.length > 515 && ArrayUtil.isSubEquals(bytes, 0, byte1)) {
                byte[] byte2 = new byte[]{-20, -91, -63, 0};
                if (ArrayUtil.isSubEquals(bytes, 512, byte2)) {
                    return true;
                }
                byte[] byte3 = new byte[]{0, 10, 0, 0, 0, 77, 83, 87, 111, 114, 100, 68, 111, 99, 0, 16, 0, 0, 0, 87, 111, 114, 100, 46, 68, 111, 99, 117, 109, 101, 110, 116, 46, 56, 0, -12, 57, -78, 113};
                byte[] range = Arrays.copyOfRange(bytes, 2075, 2142);
                return bytes.length > 2142 && FileMagicNumber.indexOf(range, byte3) > 0;
            }
            return false;
        }
    }
    ,
    XLS("application/vnd.ms-excel", "xls"){

        @Override
        public boolean match(byte[] bytes) {
            boolean flag1;
            byte[] byte1 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            boolean bl = flag1 = bytes.length > 520 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte1);
            if (flag1) {
                byte[] byte2 = new byte[]{-3, -1, -1, -1};
                boolean flag2 = Arrays.equals(Arrays.copyOfRange(bytes, 512, 516), byte2) && (bytes[518] == 0 || bytes[518] == 2);
                byte[] byte3 = new byte[]{9, 8, 16, 0, 0, 6, 5, 0};
                boolean flag3 = Arrays.equals(Arrays.copyOfRange(bytes, 512, 520), byte3);
                byte[] byte4 = new byte[]{-30, 0, 0, 0, 92, 0, 112, 0, 4, 0, 0, 67, 97, 108, 99};
                boolean flag4 = bytes.length > 2095 && Arrays.equals(Arrays.copyOfRange(bytes, 1568, 2095), byte4);
                return flag2 || flag3 || flag4;
            }
            return false;
        }
    }
    ,
    PPT("application/vnd.ms-powerpoint", "ppt"){

        @Override
        public boolean match(byte[] bytes) {
            boolean flag1;
            byte[] byte1 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
            boolean bl = flag1 = bytes.length > 524 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte1);
            if (flag1) {
                byte[] byte2 = new byte[]{-96, 70, 29, -16};
                byte[] byteRange = Arrays.copyOfRange(bytes, 512, 516);
                boolean flag2 = Arrays.equals(byteRange, byte2);
                byte[] byte3 = new byte[]{0, 110, 30, -16};
                boolean flag3 = Arrays.equals(byteRange, byte3);
                byte[] byte4 = new byte[]{15, 0, -24, 3};
                boolean flag4 = Arrays.equals(byteRange, byte4);
                byte[] byte5 = new byte[]{-3, -1, -1, -1};
                boolean flag5 = Arrays.equals(byteRange, byte5) && bytes[522] == 0 && bytes[523] == 0;
                byte[] byte6 = new byte[]{0, -71, 41, -24, 17, 0, 0, 0, 77, 83, 32, 80, 111, 119, 101, 114, 80, 111, 105, 110, 116, 32, 57, 55};
                boolean flag6 = bytes.length > 2096 && Arrays.equals(Arrays.copyOfRange(bytes, 2072, 2096), byte6);
                return flag2 || flag3 || flag4 || flag5 || flag6;
            }
            return false;
        }
    }
    ,
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx"){

        @Override
        public boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)DOCX);
        }
    }
    ,
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"){

        @Override
        public boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)PPTX);
        }
    }
    ,
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"){

        @Override
        public boolean match(byte[] bytes) {
            return Objects.equals((Object)FileMagicNumber.matchDocument(bytes), (Object)XLSX);
        }
    }
    ,
    WASM("application/wasm", "wasm"){

        @Override
        public boolean match(byte[] bytes) {
            return ArrayUtil.startWith(bytes, 0, 97, 115, 109, 1, 0, 0, 0);
        }
    }
    ,
    DEX("application/vnd.android.dex", "dex"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 36 && Objects.equals(bytes[0], (byte)100) && Objects.equals(bytes[1], (byte)101) && Objects.equals(bytes[2], (byte)120) && Objects.equals(bytes[3], (byte)10) && Objects.equals(bytes[36], (byte)112);
        }
    }
    ,
    DEY("application/vnd.android.dey", "dey"){

        @Override
        public boolean match(byte[] bytes) {
            return bytes.length > 100 && Objects.equals(bytes[0], (byte)100) && Objects.equals(bytes[1], (byte)101) && Objects.equals(bytes[2], (byte)121) && Objects.equals(bytes[3], (byte)10) && DEX.match(Arrays.copyOfRange(bytes, 40, 100));
        }
    }
    ,
    EML("message/rfc822", "eml"){

        @Override
        public boolean match(byte[] bytes) {
            if (bytes.length < 8) {
                return false;
            }
            byte[] byte1 = new byte[]{70, 114, 111, 109, 32, 32, 32};
            byte[] byte2 = new byte[]{70, 114, 111, 109, 32, 63, 63, 63};
            byte[] byte3 = new byte[]{70, 114, 111, 109, 58, 32};
            byte[] byte4 = new byte[]{82, 101, 116, 117, 114, 110, 45, 80, 97, 116, 104, 58, 32};
            return Arrays.equals(Arrays.copyOfRange(bytes, 0, 7), byte1) || Arrays.equals(Arrays.copyOfRange(bytes, 0, 8), byte2) || Arrays.equals(Arrays.copyOfRange(bytes, 0, 6), byte3) || bytes.length > 13 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 13), byte4);
        }
    }
    ,
    MDB("application/vnd.ms-access", "mdb"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
            return bytes.length > 18 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 18), byte1);
        }
    }
    ,
    CHM("application/vnd.ms-htmlhelp", "chm"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{73, 84, 83, 70};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 4), byte1);
        }
    }
    ,
    CLASS("application/java-vm", "class"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{-54, -2, -70, -66};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 4), byte1);
        }
    }
    ,
    TORRENT("application/x-bittorrent", "torrent"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{100, 56, 58, 97, 110, 110, 111, 117, 110, 99, 101};
            return bytes.length > 11 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 11), byte1);
        }
    }
    ,
    WPD("application/vnd.wordperfect", "wpd"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{-1, 87, 80, 67};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 4), byte1);
        }
    }
    ,
    DBX("", "dbx"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{-49, -83, 18, -2};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 4), byte1);
        }
    }
    ,
    PST("application/vnd.ms-outlook-pst", "pst"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{33, 66, 68, 78};
            return bytes.length > 4 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 4), byte1);
        }
    }
    ,
    RAM("audio/x-pn-realaudio", "ram"){

        @Override
        public boolean match(byte[] bytes) {
            byte[] byte1 = new byte[]{46, 114, 97, -3, 0};
            return bytes.length > 5 && Arrays.equals(Arrays.copyOfRange(bytes, 0, 5), byte1);
        }
    };

    private final String mimeType;
    private final String extension;

    public static FileMagicNumber getMagicNumber(byte[] bytes) {
        FileMagicNumber number = Arrays.stream(FileMagicNumber.values()).filter(fileMagicNumber -> fileMagicNumber.match(bytes)).findFirst().orElse(UNKNOWN);
        if (ZIP.equals((Object)number)) {
            FileMagicNumber fn = FileMagicNumber.matchDocument(bytes);
            return fn == UNKNOWN ? ZIP : fn;
        }
        return number;
    }

    private FileMagicNumber(String mimeType, String extension) {
        this.mimeType = mimeType;
        this.extension = extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public abstract boolean match(byte[] var1);

    private static int indexOf(byte[] array, byte[] target) {
        if (array == null || target == null || array.length < target.length) {
            return -1;
        }
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static boolean compareBytes(byte[] buf, byte[] slice, int startOffset) {
        int sl = slice.length;
        if (startOffset + sl > buf.length) {
            return false;
        }
        byte[] sub = Arrays.copyOfRange(buf, startOffset, startOffset + sl);
        return Arrays.equals(sub, slice);
    }

    private static FileMagicNumber matchOpenXmlMime(byte[] bytes, int offset) {
        byte[] word = new byte[]{119, 111, 114, 100, 47};
        byte[] ppt = new byte[]{112, 112, 116, 47};
        byte[] xl = new byte[]{120, 108, 47};
        if (FileMagicNumber.compareBytes(bytes, word, offset)) {
            return DOCX;
        }
        if (FileMagicNumber.compareBytes(bytes, ppt, offset)) {
            return PPTX;
        }
        if (FileMagicNumber.compareBytes(bytes, xl, offset)) {
            return XLSX;
        }
        return UNKNOWN;
    }

    private static FileMagicNumber matchDocument(byte[] bytes) {
        FileMagicNumber fileMagicNumber = FileMagicNumber.matchOpenXmlMime(bytes, 30);
        if (!fileMagicNumber.equals((Object)UNKNOWN)) {
            return fileMagicNumber;
        }
        byte[] bytes1 = new byte[]{91, 67, 111, 110, 116, 101, 110, 116, 95, 84, 121, 112, 101, 115, 93, 46, 120, 109, 108};
        byte[] bytes2 = new byte[]{95, 114, 101, 108, 115, 47, 46, 114, 101, 108, 115};
        byte[] bytes3 = new byte[]{100, 111, 99, 80, 114, 111, 112, 115};
        boolean flag1 = FileMagicNumber.compareBytes(bytes, bytes1, 30);
        boolean flag2 = FileMagicNumber.compareBytes(bytes, bytes2, 30);
        boolean flag3 = FileMagicNumber.compareBytes(bytes, bytes3, 30);
        if (!(flag1 || flag2 || flag3)) {
            return UNKNOWN;
        }
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            FileMagicNumber fn;
            if ((index = FileMagicNumber.searchSignature(bytes, index + 4, 6000)) == -1 || (fn = FileMagicNumber.matchOpenXmlMime(bytes, index + 30)).equals((Object)UNKNOWN)) continue;
            return fn;
        }
        return UNKNOWN;
    }

    private static int searchSignature(byte[] bytes, int start, int rangeNum) {
        int index;
        byte[] signature = new byte[]{80, 75, 3, 4};
        int end = start + rangeNum;
        int length = bytes.length;
        if (end > length) {
            end = length;
        }
        return (index = FileMagicNumber.indexOf(Arrays.copyOfRange(bytes, start, end), signature)) == -1 ? -1 : start + index;
    }
}

