/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.stream;

import cn.ujava.common.convert.Convert;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class StreamWriter {
    private final OutputStream out;
    private final boolean closeAfterWrite;

    public static StreamWriter of(OutputStream out, boolean closeAfterWrite) {
        return new StreamWriter(out, closeAfterWrite);
    }

    public StreamWriter(OutputStream out, boolean closeAfterWrite) {
        this.out = out;
        this.closeAfterWrite = closeAfterWrite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] content) throws IORuntimeException {
        OutputStream out = this.out;
        try {
            out.write(content);
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(out);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObj(Object ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = this.out instanceof ObjectOutputStream ? (ObjectOutputStream)this.out : new ObjectOutputStream(this.out);
            for (Object content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoUtil.closeQuietly(osw);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(osw);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeStr(Charset charset, Object ... contents) throws IORuntimeException {
        OutputStreamWriter osw = null;
        try {
            osw = IoUtil.toWriter(this.out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoUtil.closeQuietly(osw);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(osw);
        return;
    }
}

