/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.lang;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.func.SerSupplier;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.map.SafeConcurrentHashMap;
import cn.ujava.common.reflect.ConstructorUtil;
import cn.ujava.common.text.StrUtil;
import java.util.Set;
import java.util.stream.Collectors;

public final class Singleton {
    private static final SafeConcurrentHashMap<String, Object> POOL = new SafeConcurrentHashMap();

    private Singleton() {
    }

    public static <T> T get(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        return (T)Singleton.get(key, () -> ConstructorUtil.newInstance(clazz, params));
    }

    public static <T> T get(String key, SerSupplier<T> supplier) {
        return (T)POOL.computeIfAbsent(key, k -> supplier.get());
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        Singleton.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static boolean exists(Class<?> clazz, Object ... params) {
        if (null != clazz) {
            String key = Singleton.buildKey(clazz.getName(), params);
            return POOL.containsKey(key);
        }
        return false;
    }

    public static Set<Class<?>> getExistClass() {
        return POOL.values().stream().map(Object::getClass).collect(Collectors.toSet());
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Singleton.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return className;
        }
        return StrUtil.format("{}#{}", className, ArrayUtil.join(params, (CharSequence)"_"));
    }
}

