/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.lang.range;

import cn.ujava.common.lang.range.Bound;
import cn.ujava.common.lang.range.BoundType;
import cn.ujava.common.lang.range.BoundedRange;

class NoneLowerBound<T extends Comparable<? super T>>
implements Bound<T> {
    static final NoneLowerBound INSTANCE = new NoneLowerBound();

    private NoneLowerBound() {
    }

    @Override
    public T getValue() {
        return null;
    }

    @Override
    public BoundType getType() {
        return BoundType.OPEN_LOWER_BOUND;
    }

    @Override
    public boolean test(T t) {
        return true;
    }

    @Override
    public int compareTo(Bound<T> bound) {
        return bound instanceof NoneLowerBound ? 0 : -1;
    }

    @Override
    public String descBound() {
        return this.getType().getSymbol() + "-\u221e";
    }

    @Override
    public Bound<T> negate() {
        return this;
    }

    @Override
    public BoundedRange<T> toRange() {
        return BoundedRange.all();
    }

    @Override
    public String toString() {
        return "{x | x > -\u221e}";
    }
}

