/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.reflect;

import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.map.WeakConcurrentMap;
import cn.ujava.common.reflect.ClassUtil;
import cn.ujava.common.reflect.ReflectUtil;
import cn.ujava.common.reflect.lookup.LookupUtil;
import cn.ujava.common.reflect.method.MethodHandleUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConstructorUtil {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ConstructorUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, key -> ConstructorUtil.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static <T> T newInstance(String clazz) throws HutoolException {
        return ConstructorUtil.newInstance(ClassLoaderUtil.loadClass(clazz), new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws HutoolException {
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        MethodHandle constructor = LookupUtil.findConstructor(clazz, paramTypes);
        return MethodHandleUtil.invokeHandle(constructor, params);
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)ClassUtil.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)ConstructorUtil.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = ConstructorUtil.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtil.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(ClassUtil.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

