/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.reflect.method;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.lang.mutable.MutableObj;
import cn.ujava.common.map.MapUtil;
import cn.ujava.common.map.WeakConcurrentMap;
import cn.ujava.common.reflect.ClassUtil;
import cn.ujava.common.reflect.method.MethodMetadataLookup;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MethodScanner {
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> DECLARED_METHODS_CACHE = new WeakConcurrentMap();

    public static Method[] getMethods(Class<?> type) {
        if (Objects.isNull(type)) {
            return EMPTY_METHODS;
        }
        return MapUtil.computeIfAbsentForJdk8(METHODS_CACHE, type, Class::getMethods);
    }

    public static Method[] getDeclaredMethods(Class<?> type) {
        if (Objects.isNull(type)) {
            return EMPTY_METHODS;
        }
        return MapUtil.computeIfAbsentForJdk8(DECLARED_METHODS_CACHE, type, Class::getDeclaredMethods);
    }

    public static Method[] getAllMethods(Class<?> type) {
        if (Objects.isNull(type)) {
            return EMPTY_METHODS;
        }
        ArrayList methods = new ArrayList();
        ClassUtil.traverseTypeHierarchyWhile(type, t -> {
            methods.addAll(Arrays.asList(MethodScanner.getDeclaredMethods(t)));
            return true;
        });
        return methods.isEmpty() ? EMPTY_METHODS : methods.toArray(new Method[0]);
    }

    public static void clearCaches() {
        METHODS_CACHE.clear();
        DECLARED_METHODS_CACHE.clear();
    }

    public static <T> Map<Method, T> findWithMetadataFromSpecificMethods(Method[] methods, MethodMetadataLookup<T> lookup) {
        if (ArrayUtil.isEmpty(methods)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Method, T> results = new LinkedHashMap<Method, T>();
        for (Method method : methods) {
            T result = lookup.inspect(method);
            if (!Objects.nonNull(result)) continue;
            results.put(method, result);
        }
        return results;
    }

    public static Set<Method> findFromSpecificMethods(Method[] methods, MethodMetadataLookup<?> lookup) {
        return MethodScanner.findWithMetadataFromSpecificMethods(methods, lookup).keySet();
    }

    public static <T> Map.Entry<Method, T> getWithMetadataFromSpecificMethods(Method[] methods, MethodMetadataLookup<T> lookup) {
        for (Method method : methods) {
            T result = lookup.inspect(method);
            if (!Objects.nonNull(result)) continue;
            return MapUtil.entry(method, result);
        }
        return null;
    }

    public static Method getFromSpecificMethods(Method[] methods, MethodMetadataLookup<?> lookup) {
        Map.Entry<Method, ?> result = MethodScanner.getWithMetadataFromSpecificMethods(methods, lookup);
        return Objects.isNull(result) ? null : result.getKey();
    }

    public static <T> Map<Method, T> findWithMetadataFromMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        return MethodScanner.findWithMetadataFromSpecificMethods(MethodScanner.getMethods(type), lookup);
    }

    public static Set<Method> findFromMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        return MethodScanner.findFromSpecificMethods(MethodScanner.getMethods(type), lookup);
    }

    public static <T> Map.Entry<Method, T> getWithMetadataFromMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        return MethodScanner.getWithMetadataFromSpecificMethods(MethodScanner.getMethods(type), lookup);
    }

    public static Method getFromMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        return MethodScanner.getFromSpecificMethods(MethodScanner.getMethods(type), lookup);
    }

    public static <T> Map<Method, T> findWithMetadataFromDeclaredMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        return MethodScanner.findWithMetadataFromSpecificMethods(MethodScanner.getDeclaredMethods(type), lookup);
    }

    public static Set<Method> findFromDeclaredMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        return MethodScanner.findFromSpecificMethods(MethodScanner.getDeclaredMethods(type), lookup);
    }

    public static <T> Map.Entry<Method, T> getWithMetadataFromDeclaredMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        return MethodScanner.getWithMetadataFromSpecificMethods(MethodScanner.getDeclaredMethods(type), lookup);
    }

    public static Method getFromDeclaredMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        return MethodScanner.getFromSpecificMethods(MethodScanner.getDeclaredMethods(type), lookup);
    }

    public static <T> Map<Method, T> findWithMetadataFromAllMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        return MethodScanner.findWithMetadataFromSpecificMethods(MethodScanner.getAllMethods(type), lookup);
    }

    public static Set<Method> findFromAllMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        return MethodScanner.findFromSpecificMethods(MethodScanner.getAllMethods(type), lookup);
    }

    public static <T> Map.Entry<Method, T> getWithMetadataFromAllMethods(Class<?> type, MethodMetadataLookup<T> lookup) {
        if (Objects.isNull(type)) {
            return null;
        }
        MutableObj result = new MutableObj();
        ClassUtil.traverseTypeHierarchyWhile(type, t -> {
            Map.Entry target = MethodScanner.getWithMetadataFromDeclaredMethods(t, lookup);
            if (Objects.nonNull(target)) {
                result.set(target);
                return false;
            }
            return true;
        });
        return (Map.Entry)result.get();
    }

    public static Method getFromAllMethods(Class<?> type, MethodMetadataLookup<?> lookup) {
        Map.Entry<Method, ?> target = MethodScanner.getWithMetadataFromAllMethods(type, lookup);
        return Objects.isNull(target) ? null : target.getKey();
    }
}

