/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.stream;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.stream.CollectorUtil;
import cn.ujava.common.stream.spliterators.DropWhileSpliterator;
import cn.ujava.common.stream.spliterators.IterateSpliterator;
import cn.ujava.common.stream.spliterators.TakeWhileSpliterator;
import cn.ujava.common.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        Assert.notNull(array, "Array must be not null!", new Object[0]);
        return Stream.of(array);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        Assert.notNull(iterable, "Iterable must be not null!", new Object[0]);
        return iterable instanceof Collection ? (parallel ? ((Collection)iterable).parallelStream() : ((Collection)iterable).stream()) : StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator) {
        return StreamUtil.ofIter(iterator, false);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator, boolean parallel) {
        Assert.notNull(iterator, "iterator must not be null!", new Object[0]);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), parallel);
    }

    public static Stream<String> of(File file) {
        return StreamUtil.of(file, CharsetUtil.UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamUtil.of(path, CharsetUtil.UTF_8);
    }

    public static Stream<String> of(File file, Charset charset) {
        Assert.notNull(file, "File must be not null!", new Object[0]);
        return StreamUtil.of(file.toPath(), charset);
    }

    public static Stream<String> of(Path path, Charset charset) {
        try {
            return Files.lines(path, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        return stream.collect(CollectorUtil.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return stream.collect(CollectorUtil.joining(delimiter, toStringFunc));
    }

    public static <T> Stream<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        return StreamSupport.stream(IterateSpliterator.create(seed, hasNext, next), false);
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<? super T> predicate) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(predicate);
        return StreamUtil.createStatefulNewStream(source, TakeWhileSpliterator.create(source.spliterator(), predicate));
    }

    public static <T> Stream<T> dropWhile(Stream<T> source, Predicate<? super T> predicate) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(predicate);
        return StreamUtil.createStatefulNewStream(source, DropWhileSpliterator.create(source.spliterator(), predicate));
    }

    private static <T, R> Stream<R> createStatefulNewStream(Stream<T> source, Spliterator<R> newSpliterator) {
        Stream<R> newStream = StreamSupport.stream(newSpliterator, source.isParallel());
        if (source.isParallel()) {
            newStream = newStream.limit(Long.MAX_VALUE);
        }
        return (Stream)newStream.onClose(source::close);
    }
}

