/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text;

import cn.ujava.common.text.StrUtil;
import java.io.Serializable;
import java.util.function.BiPredicate;

public class StrRegionMatcher
implements BiPredicate<CharSequence, CharSequence>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean ignoreCase;
    private final boolean ignoreEquals;
    private final int offset;

    public StrRegionMatcher(boolean ignoreCase, boolean ignoreEquals, boolean isPrefix) {
        this(ignoreCase, ignoreEquals, isPrefix ? 0 : -1);
    }

    public StrRegionMatcher(boolean ignoreCase, boolean ignoreEquals, int offset) {
        this.ignoreCase = ignoreCase;
        this.ignoreEquals = ignoreEquals;
        this.offset = offset;
    }

    @Override
    public boolean test(CharSequence str, CharSequence strToCheck) {
        if (null == str || null == strToCheck) {
            if (this.ignoreEquals) {
                return false;
            }
            return null == str && null == strToCheck;
        }
        int strToCheckLength = strToCheck.length();
        int toffset = this.offset >= 0 ? this.offset : str.length() - strToCheckLength + this.offset + 1;
        boolean matches = str.toString().regionMatches(this.ignoreCase, toffset, strToCheck.toString(), 0, strToCheckLength);
        if (matches) {
            return !this.ignoreEquals || !StrUtil.equals(str, strToCheck, this.ignoreCase);
        }
        return false;
    }
}

