/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text;

import cn.ujava.common.text.CharUtil;
import cn.ujava.common.text.StrUtil;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class StrTrimer
implements UnaryOperator<CharSequence>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static StrTrimer TRIM_BLANK = new StrTrimer(TrimMode.BOTH, CharUtil::isBlankChar);
    public static StrTrimer TRIM_PREFIX_BLANK = new StrTrimer(TrimMode.PREFIX, CharUtil::isBlankChar);
    public static StrTrimer TRIM_SUFFIX_BLANK = new StrTrimer(TrimMode.SUFFIX, CharUtil::isBlankChar);
    private final TrimMode mode;
    private final Predicate<Character> predicate;

    public StrTrimer(TrimMode mode, Predicate<Character> predicate) {
        this.mode = mode;
        this.predicate = predicate;
    }

    @Override
    public String apply(CharSequence str) {
        int begin;
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int length = str.length();
        int end = length;
        if (this.mode == TrimMode.PREFIX || this.mode == TrimMode.BOTH) {
            for (begin = 0; begin < end && this.predicate.test(Character.valueOf(str.charAt(begin))); ++begin) {
            }
        }
        if (this.mode == TrimMode.SUFFIX || this.mode == TrimMode.BOTH) {
            while (begin < end && this.predicate.test(Character.valueOf(str.charAt(end - 1)))) {
                --end;
            }
        }
        String result = begin > 0 || end < length ? str.toString().substring(begin, end) : str.toString();
        return result;
    }

    public static enum TrimMode {
        PREFIX,
        SUFFIX,
        BOTH;

    }
}

