/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.placeholder;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.lang.mutable.MutableEntry;
import cn.ujava.common.map.WeakConcurrentMap;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.text.placeholder.StrTemplate;
import cn.ujava.common.text.placeholder.template.NamedPlaceholderStrTemplate;
import cn.ujava.common.text.placeholder.template.SinglePlaceholderStrTemplate;
import java.util.Map;

public class StrFormatter {
    private static final WeakConcurrentMap<Map.Entry<CharSequence, Object>, StrTemplate> CACHE = new WeakConcurrentMap();

    public static String format(String strPattern, Object ... argArray) {
        return StrFormatter.formatWith(strPattern, "{}", argArray);
    }

    public static String formatWith(String strPattern, String placeHolder, Object ... argArray) {
        if (StrUtil.isBlank(strPattern) || StrUtil.isBlank(placeHolder) || ArrayUtil.isEmpty(argArray)) {
            return strPattern;
        }
        return ((SinglePlaceholderStrTemplate)CACHE.computeIfAbsent(MutableEntry.of(strPattern, placeHolder), k -> (SinglePlaceholderStrTemplate)StrTemplate.of(strPattern).placeholder(placeHolder).build())).format(argArray);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        return ((NamedPlaceholderStrTemplate)CACHE.computeIfAbsent(MutableEntry.of(template, ignoreNull), k -> {
            NamedPlaceholderStrTemplate.Builder builder = StrTemplate.ofNamed(template.toString());
            if (ignoreNull) {
                builder.addFeatures(StrTemplate.Feature.FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER);
            } else {
                builder.addFeatures(StrTemplate.Feature.FORMAT_NULL_VALUE_TO_EMPTY);
            }
            return builder.build();
        })).format(map);
    }

    public static void clear() {
        CACHE.clear();
    }
}

