/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.split;

import cn.ujava.common.collection.ListUtil;
import cn.ujava.common.convert.Convert;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.regex.PatternPool;
import cn.ujava.common.text.CharSequenceUtil;
import cn.ujava.common.text.CharUtil;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.text.finder.CharFinder;
import cn.ujava.common.text.finder.CharMatcherFinder;
import cn.ujava.common.text.finder.LengthFinder;
import cn.ujava.common.text.finder.PatternFinder;
import cn.ujava.common.text.finder.StrFinder;
import cn.ujava.common.text.finder.TextFinder;
import cn.ujava.common.text.split.SplitIter;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class SplitUtil {
    public static int UNLIMITED = -1;

    public static <T> T splitTo(CharSequence str, CharSequence separator, Class<T> resultType) {
        return Convert.convert(resultType, SplitUtil.splitTrim(str, separator));
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return SplitUtil.split(str, separator, true, true);
    }

    public static String[] splitToArray(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        return SplitUtil.toArray(SplitUtil.split(str, separator));
    }

    public static List<String> split(CharSequence str, CharSequence separator) {
        return SplitUtil.split(str, separator, false, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return SplitUtil.split(str, separator, UNLIMITED, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return SplitUtil.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return SplitUtil.split(str, separator, limit, ignoreEmpty, ignoreCase, SplitUtil.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence str, CharSequence separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == str) {
            return ListUtil.zero();
        }
        if (0 == str.length() && ignoreEmpty) {
            return ListUtil.zero();
        }
        Assert.notEmpty(separator, "Separator must be not empty!", new Object[0]);
        TextFinder finder = separator.length() == 1 ? new CharFinder(separator.charAt(0), ignoreCase) : StrFinder.of(separator, ignoreCase);
        SplitIter splitIter = new SplitIter(str, finder, limit, ignoreEmpty);
        return splitIter.toList(mapping);
    }

    public static List<String> splitPath(CharSequence str) {
        return SplitUtil.splitPath(str, UNLIMITED);
    }

    public static List<String> splitPath(CharSequence str, int limit) {
        if (StrUtil.isBlank(str)) {
            return ListUtil.zero();
        }
        SplitIter splitIter = new SplitIter(str, new CharMatcherFinder(c -> c.charValue() == '/' || c.charValue() == '\\'), limit, true);
        return splitIter.toList(false);
    }

    public static List<String> splitByBlank(CharSequence str) {
        return SplitUtil.splitByBlank(str, UNLIMITED);
    }

    public static List<String> splitByBlank(CharSequence str, int limit) {
        if (StrUtil.isBlank(str)) {
            return ListUtil.zero();
        }
        SplitIter splitIter = new SplitIter(str, new CharMatcherFinder(CharUtil::isBlankChar), limit, true);
        return splitIter.toList(false);
    }

    public static String[] splitByBlankToArray(CharSequence str, int limit) {
        return SplitUtil.toArray(SplitUtil.splitByBlank(str, limit));
    }

    public static List<String> splitByRegex(CharSequence str, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternPool.get(separatorRegex);
        return SplitUtil.splitByRegex(str, pattern, limit, isTrim, ignoreEmpty);
    }

    public static List<String> splitByRegex(CharSequence str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StrUtil.isEmpty(str)) {
            return ListUtil.zero();
        }
        SplitIter splitIter = new SplitIter(str, new PatternFinder(separatorPattern), limit, ignoreEmpty);
        return splitIter.toList(isTrim);
    }

    public static String[] splitByRegexToArray(CharSequence str, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return SplitUtil.toArray(SplitUtil.splitByRegex(str, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitByLength(CharSequence str, int len) {
        if (StrUtil.isEmpty(str)) {
            return new String[0];
        }
        SplitIter splitIter = new SplitIter(str, new LengthFinder(len), -1, false);
        return splitIter.toArray(false);
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static Function<String, String> trimFunc(boolean isTrim) {
        return isTrim ? CharSequenceUtil::trim : Function.identity();
    }
}

