/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.thread;

import cn.ujava.common.thread.ThreadUtil;
import cn.ujava.common.util.RuntimeUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SimpleScheduler<T> {
    private final Job<T> job;

    public SimpleScheduler(Job<T> job, long period) {
        this(job, 0L, period, true);
    }

    public SimpleScheduler(Job<T> job, long initialDelay, long period, boolean fixedRateOrFixedDelay) {
        this.job = job;
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ThreadUtil.schedule(scheduler, job, initialDelay, period, fixedRateOrFixedDelay);
        RuntimeUtil.addShutdownHook(scheduler::shutdown);
    }

    public T getResult() {
        return this.job.getResult();
    }

    public static interface Job<T>
    extends Runnable {
        public T getResult();
    }
}

