/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.thread;

import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.thread.ExecutorBuilder;
import cn.ujava.common.thread.NamedThreadFactory;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public class SyncFinisher
implements Closeable {
    private final Set<Worker> workers;
    private final int threadSize;
    private ExecutorService executorService;
    private boolean isBeginAtSameTime;
    private final CountDownLatch beginLatch = new CountDownLatch(1);
    private CountDownLatch endLatch;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    public SyncFinisher(int threadSize) {
        this.threadSize = threadSize;
        this.workers = new LinkedHashSet<Worker>();
    }

    public SyncFinisher setBeginAtSameTime(boolean isBeginAtSameTime) {
        this.isBeginAtSameTime = isBeginAtSameTime;
        return this;
    }

    public SyncFinisher setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public SyncFinisher addRepeatWorker(final Runnable runnable) {
        for (int i = 0; i < this.threadSize; ++i) {
            this.addWorker(new Worker(){

                @Override
                public void work() {
                    runnable.run();
                }
            });
        }
        return this;
    }

    public SyncFinisher addWorker(final Runnable runnable) {
        return this.addWorker(new Worker(){

            @Override
            public void work() {
                runnable.run();
            }
        });
    }

    public synchronized SyncFinisher addWorker(Worker worker) {
        this.workers.add(worker);
        return this;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean sync) {
        this.endLatch = new CountDownLatch(this.workers.size());
        if (null == this.executorService || this.executorService.isShutdown()) {
            this.executorService = this.buildExecutor();
        }
        for (Worker worker : this.workers) {
            this.executorService.execute(worker);
        }
        this.beginLatch.countDown();
        if (sync) {
            try {
                this.endLatch.await();
            }
            catch (InterruptedException e) {
                throw new HutoolException(e);
            }
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean isStopNow) {
        if (null != this.executorService) {
            if (isStopNow) {
                this.executorService.shutdownNow();
            } else {
                this.executorService.shutdown();
            }
            this.executorService = null;
        }
        this.clearWorker();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.endLatch.getCount();
    }

    @Override
    public void close() {
        this.stop();
    }

    private ExecutorService buildExecutor() {
        return ExecutorBuilder.of().setCorePoolSize(this.threadSize).setThreadFactory(new NamedThreadFactory("hutool-", null, false, this.exceptionHandler)).build();
    }

    public abstract class Worker
    implements Runnable {
        @Override
        public void run() {
            if (SyncFinisher.this.isBeginAtSameTime) {
                try {
                    SyncFinisher.this.beginLatch.await();
                }
                catch (InterruptedException e) {
                    throw new HutoolException(e);
                }
            }
            try {
                this.work();
            }
            finally {
                SyncFinisher.this.endLatch.countDown();
            }
        }

        public abstract void work();
    }
}

