/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.tree;

import cn.ujava.common.collection.CollUtil;
import cn.ujava.common.tree.MapTree;
import cn.ujava.common.tree.TreeBuilder;
import cn.ujava.common.tree.TreeNode;
import cn.ujava.common.tree.TreeNodeConfig;
import cn.ujava.common.tree.parser.DefaultNodeParser;
import cn.ujava.common.tree.parser.NodeParser;
import cn.ujava.common.util.ObjUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TreeUtil {
    public static MapTree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeUtil.buildSingle(list, Integer.valueOf(0));
    }

    public static List<MapTree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    public static <E> MapTree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<MapTree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> MapTree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, rootId, treeNodeConfig, nodeParser).getChildren();
    }

    public static <T, E> MapTree<E> buildSingle(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, treeNodeConfig).append(list, nodeParser).build();
    }

    public static <E> List<MapTree<E>> build(Map<E, MapTree<E>> map, E rootId) {
        return TreeUtil.buildSingle(map, rootId).getChildren();
    }

    public static <E> MapTree<E> buildSingle(Map<E, MapTree<E>> map, E rootId) {
        MapTree<E> tree = CollUtil.getFirstNoneNull(map.values());
        if (null != tree) {
            TreeNodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeUtil.createEmptyNode(rootId);
    }

    public static <T> MapTree<T> getNode(MapTree<T> node, T id) {
        if (ObjUtil.equals(id, node.getId())) {
            return node;
        }
        List<MapTree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (MapTree<T> child : children) {
            MapTree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(MapTree<T> node, boolean includeCurrentNode) {
        return TreeUtil.getParents(node, includeCurrentNode, MapTree::getName);
    }

    public static <T> List<T> getParentsId(MapTree<T> node, boolean includeCurrentNode) {
        return TreeUtil.getParents(node, includeCurrentNode, MapTree::getId);
    }

    public static <T, E> List<E> getParents(MapTree<T> node, boolean includeCurrentNode, Function<MapTree<T>, E> fieldFunc) {
        ArrayList<E> result = new ArrayList<E>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(fieldFunc.apply(node));
        }
        for (MapTree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            E fieldValue = fieldFunc.apply(parent);
            if (null == fieldValue && null == parent) continue;
            result.add(fieldValue);
        }
        return result;
    }

    public static <E> MapTree<E> createEmptyNode(E id) {
        return new MapTree().setId(id);
    }

    public static <E> List<MapTree<E>> toList(MapTree<E> root, boolean broadFirst) {
        if (Objects.isNull(root)) {
            return null;
        }
        ArrayList<MapTree<E>> list = new ArrayList<MapTree<E>>();
        root.walk(list::add, broadFirst);
        return list;
    }
}

