/*
 * Decompiled with CFR 0.152.
 */
package dev.acdcjunior.immutable;

import dev.acdcjunior.immutable.IList;
import dev.acdcjunior.immutable.IOption;
import dev.acdcjunior.immutable.fn.IConsumer;
import dev.acdcjunior.immutable.fn.IFunction;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IEither<L, R>
implements Iterable<R> {
    @NotNull
    public static <L, R> IEither<L, R> left(@NotNull L left) {
        return new Left(left);
    }

    @NotNull
    public static <L, R> IEither<L, R> right(@NotNull R right) {
        return new Right(right);
    }

    @NotNull
    public abstract IList<R> toList();

    @Nullable
    public abstract L left();

    @Nullable
    public abstract R right();

    public abstract boolean isLeft();

    public boolean isDefined() {
        return !this.isLeft();
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return this.toList().iterator();
    }

    @NotNull
    public abstract IOption<R> toOption();

    @NotNull
    public abstract IOption<L> toOptionLeft();

    @NotNull
    public abstract IEither<L, R> ifLeft(@NotNull IConsumer<L> var1);

    @NotNull
    public abstract IEither<L, R> ifRight(@NotNull IConsumer<R> var1);

    @NotNull
    public abstract <R2> IEither<L, R2> map(@NotNull IFunction<? super R, R2> var1);

    @NotNull
    public abstract <L2> IEither<L2, R> mapLeft(@NotNull IFunction<? super L, L2> var1);

    @NotNull
    public abstract <R2> IEither<L, R2> flatMap(@NotNull IFunction<? super R, IEither<L, R2>> var1);

    public static final class Right<L, R>
    extends IEither<L, R> {
        @NotNull
        private final R value;

        private Right(@NotNull R value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument of IEither.Right cannot be null");
            }
            this.value = value;
        }

        @NotNull
        public R getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Right(%s)", this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return this.value.equals(right.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        @NotNull
        public IList<R> toList() {
            return IList.listOf(this.value);
        }

        @Override
        @Nullable
        public L left() {
            return null;
        }

        @Override
        @NotNull
        public R right() {
            return this.getValue();
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        @NotNull
        public IOption<R> toOption() {
            return IOption.some(this.getValue());
        }

        @Override
        @NotNull
        public IOption<L> toOptionLeft() {
            return IOption.none();
        }

        @Override
        @NotNull
        public IEither<L, R> ifLeft(@NotNull IConsumer<L> fn) {
            return this;
        }

        @Override
        @NotNull
        public IEither<L, R> ifRight(@NotNull IConsumer<R> fn) {
            fn.accept(this.getValue());
            return this;
        }

        @Override
        @NotNull
        public <R2> IEither<L, R2> map(@NotNull IFunction<? super R, R2> mapper) {
            return new Right<L, R2>(mapper.apply(this.getValue()));
        }

        @Override
        @NotNull
        public <L2> IEither<L2, R> mapLeft(@NotNull IFunction<? super L, L2> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <R2> IEither<L, R2> flatMap(@NotNull IFunction<? super R, IEither<L, R2>> mapper) {
            return mapper.apply(this.getValue());
        }
    }

    public static final class Left<L, R>
    extends IEither<L, R> {
        @NotNull
        private final L value;

        private Left(@NotNull L value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument of IEither.Left cannot be null");
            }
            this.value = value;
        }

        @NotNull
        public L getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Left(%s)", this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left right = (Left)o;
            return this.value.equals(right.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        @NotNull
        public IList<R> toList() {
            return IList.emptyList();
        }

        @Override
        @NotNull
        public L left() {
            return this.getValue();
        }

        @Override
        @Nullable
        public R right() {
            return null;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        @NotNull
        public IOption<R> toOption() {
            return IOption.none();
        }

        @Override
        @NotNull
        public IOption<L> toOptionLeft() {
            return IOption.some(this.getValue());
        }

        @Override
        @NotNull
        public IEither<L, R> ifLeft(@NotNull IConsumer<L> fn) {
            fn.accept(this.getValue());
            return this;
        }

        @Override
        @NotNull
        public IEither<L, R> ifRight(@NotNull IConsumer<R> fn) {
            return this;
        }

        @Override
        @NotNull
        public <R2> IEither<L, R2> map(@NotNull IFunction<? super R, R2> mapper) {
            return this;
        }

        @Override
        @NotNull
        public <L2> IEither<L2, R> mapLeft(@NotNull IFunction<? super L, L2> mapper) {
            return new Left<L2, R>(mapper.apply(this.getValue()));
        }

        @Override
        @NotNull
        public <R2> IEither<L, R2> flatMap(@NotNull IFunction<? super R, IEither<L, R2>> mapper) {
            return this;
        }
    }
}

