/*
 * Decompiled with CFR 0.152.
 */
package dev.acdcjunior.immutable;

import dev.acdcjunior.immutable.IEither;
import dev.acdcjunior.immutable.fn.ICommand;
import dev.acdcjunior.immutable.fn.IConsumer;
import dev.acdcjunior.immutable.fn.IFunction;
import dev.acdcjunior.immutable.fn.ISupplier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IOption<T>
implements Iterable<T> {
    @NotNull
    public abstract List<T> toList();

    @Nullable
    public abstract T orNull();

    @NotNull
    public abstract T getOrElse(@NotNull T var1);

    @NotNull
    public abstract T getOrElse(@NotNull ISupplier<? extends T> var1);

    @NotNull
    public abstract T get();

    public abstract boolean isEmpty();

    public boolean isDefined() {
        return !this.isEmpty();
    }

    @NotNull
    public abstract IOption<T> ifEmpty(@NotNull ICommand var1);

    @NotNull
    public abstract IOption<T> ifDefined(@NotNull IConsumer<? super T> var1);

    @NotNull
    public abstract IOption<T> orElse(@NotNull T var1);

    @NotNull
    public abstract IOption<T> orElse(@NotNull ISupplier<? extends T> var1);

    @NotNull
    public abstract IOption<T> orElseFlat(@NotNull IOption<T> var1);

    @NotNull
    public abstract IOption<T> orElseFlat(@NotNull ISupplier<IOption<T>> var1);

    @NotNull
    public abstract IOption<T> filter(@NotNull IFunction<? super T, Boolean> var1);

    @NotNull
    public abstract <R> IOption<R> map(@NotNull IFunction<? super T, R> var1);

    @NotNull
    public abstract <R> IOption<R> flatMap(@NotNull IFunction<? super T, IOption<R>> var1);

    @Override
    public abstract void forEach(@NotNull IConsumer<? super T> var1);

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    @NotNull
    public static <R> IOption<R> some(@NotNull R value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument of IOption.Some cannot be null");
        }
        return new Some(value);
    }

    @NotNull
    public static <R> IOption<R> none() {
        return None.NONE;
    }

    @NotNull
    public static <R> IOption<R> ofNullable(@Nullable R value) {
        return value == null ? IOption.none() : IOption.some(value);
    }

    @NotNull
    public abstract <L> IEither<L, T> toEither(ISupplier<L> var1);

    public static final class None<T>
    extends IOption<T> {
        public static final None<?> NONE = new None();

        private None() {
        }

        public String toString() {
            return "None";
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return None.class.hashCode();
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull T orElse) {
            return orElse;
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull ISupplier<? extends T> orElseFn) {
            return orElseFn.get();
        }

        @Override
        @NotNull
        public T get() {
            throw new IllegalStateException("IOption.None has no value");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public IOption<T> ifEmpty(@NotNull ICommand fn) {
            fn.run();
            return this;
        }

        @Override
        @NotNull
        public IOption<T> ifDefined(@NotNull IConsumer<? super T> fn) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> orElse(@NotNull T orElse) {
            return None.some(orElse);
        }

        @Override
        @NotNull
        public IOption<T> orElse(@NotNull ISupplier<? extends T> orElseFn) {
            return IOption.ofNullable(orElseFn.get());
        }

        @Override
        @NotNull
        public IOption<T> orElseFlat(@NotNull IOption<T> orElse) {
            return orElse;
        }

        @Override
        @NotNull
        public IOption<T> orElseFlat(@NotNull ISupplier<IOption<T>> orElseFn) {
            return orElseFn.get();
        }

        @Override
        @NotNull
        public IOption<T> filter(@NotNull IFunction<? super T, Boolean> fn) {
            return this;
        }

        @Override
        @NotNull
        public <R> IOption<R> map(@NotNull IFunction<? super T, R> fn) {
            return None.none();
        }

        @Override
        @NotNull
        public <R> IOption<R> flatMap(@NotNull IFunction<? super T, IOption<R>> fn) {
            return None.none();
        }

        @Override
        public void forEach(@NotNull IConsumer<? super T> fn) {
        }

        @Override
        @NotNull
        public <L> IEither<L, T> toEither(ISupplier<L> ifNone) {
            return IEither.left(ifNone.get());
        }

        @Override
        @NotNull
        public List<T> toList() {
            return Collections.emptyList();
        }
    }

    public static final class Some<T>
    extends IOption<T> {
        @NotNull
        private final T value;

        private Some(@NotNull T value) {
            this.value = value;
        }

        public String toString() {
            return String.format("Some(%s)", this.orNull());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Some some = (Some)o;
            return this.value.equals(some.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        @NotNull
        public T orNull() {
            return this.get();
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull T orElse) {
            return this.get();
        }

        @Override
        @NotNull
        public T getOrElse(@NotNull ISupplier<? extends T> orElseFn) {
            return this.get();
        }

        @Override
        @NotNull
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public IOption<T> ifEmpty(@NotNull ICommand fn) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> ifDefined(@NotNull IConsumer<? super T> fn) {
            fn.accept(this.orNull());
            return this;
        }

        @Override
        @NotNull
        public IOption<T> orElse(@NotNull T orElse) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> orElse(@NotNull ISupplier<? extends T> orElseFn) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> orElseFlat(@NotNull IOption<T> orElse) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> orElseFlat(@NotNull ISupplier<IOption<T>> orElseFn) {
            return this;
        }

        @Override
        @NotNull
        public IOption<T> filter(@NotNull IFunction<? super T, Boolean> fn) {
            return Boolean.TRUE.equals(this.map(fn).orNull()) ? this : IOption.none();
        }

        @Override
        @NotNull
        public <R> IOption<R> map(@NotNull IFunction<? super T, R> fn) {
            return Some.ofNullable(fn.apply(this.orNull()));
        }

        @Override
        @NotNull
        public <R> IOption<R> flatMap(@NotNull IFunction<? super T, IOption<R>> fn) {
            IOption<R> r = fn.apply(this.orNull());
            if (r == null) {
                return IOption.none();
            }
            return r;
        }

        @Override
        public void forEach(@NotNull IConsumer<? super T> fn) {
            fn.accept(this.orNull());
        }

        @Override
        @NotNull
        public <L> IEither<L, T> toEither(ISupplier<L> ifNone) {
            return IEither.right(this.get());
        }

        @Override
        @NotNull
        public List<T> toList() {
            return Collections.singletonList(this.orNull());
        }
    }
}

