// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: tensorflow_metadata/proto/v0/statistics.proto

package org.tensorflow.metadata.v0;

/**
 * <pre>
 * The data used to create a rank histogram of a non-numeric feature of a
 * dataset. The rank of a value in a feature can be used as a measure of how
 * commonly the value is found in the entire dataset. With bucket sizes of one,
 * this becomes a distribution function of all feature values.
 * </pre>
 *
 * Protobuf type {@code tensorflow.metadata.v0.RankHistogram}
 */
public final class RankHistogram extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:tensorflow.metadata.v0.RankHistogram)
    RankHistogramOrBuilder {
private static final long serialVersionUID = 0L;
  // Use RankHistogram.newBuilder() to construct.
  private RankHistogram(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private RankHistogram() {
    buckets_ = java.util.Collections.emptyList();
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new RankHistogram();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private RankHistogram(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              buckets_ = new java.util.ArrayList<org.tensorflow.metadata.v0.RankHistogram.Bucket>();
              mutable_bitField0_ |= 0x00000001;
            }
            buckets_.add(
                input.readMessage(org.tensorflow.metadata.v0.RankHistogram.Bucket.parser(), extensionRegistry));
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        buckets_ = java.util.Collections.unmodifiableList(buckets_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.tensorflow.metadata.v0.RankHistogram.class, org.tensorflow.metadata.v0.RankHistogram.Builder.class);
  }

  public interface BucketOrBuilder extends
      // @@protoc_insertion_point(interface_extends:tensorflow.metadata.v0.RankHistogram.Bucket)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The low rank of the bucket, inclusive.
     * </pre>
     *
     * <code>uint64 low_rank = 1;</code>
     * @return The lowRank.
     */
    long getLowRank();

    /**
     * <pre>
     * The high rank of the bucket, exclusive.
     * </pre>
     *
     * <code>uint64 high_rank = 2;</code>
     * @return The highRank.
     */
    long getHighRank();

    /**
     * <pre>
     * The label for the bucket. Can be used to list or summarize the values in
     * this rank bucket.
     * </pre>
     *
     * <code>string label = 4;</code>
     * @return The label.
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * The label for the bucket. Can be used to list or summarize the values in
     * this rank bucket.
     * </pre>
     *
     * <code>string label = 4;</code>
     * @return The bytes for label.
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <pre>
     * The number of items in the bucket. Stored as a double to be able to
     * handle weighted histograms.
     * </pre>
     *
     * <code>double sample_count = 5;</code>
     * @return The sampleCount.
     */
    double getSampleCount();
  }
  /**
   * <pre>
   * Each bucket defines its start and end ranks along with its count.
   * </pre>
   *
   * Protobuf type {@code tensorflow.metadata.v0.RankHistogram.Bucket}
   */
  public static final class Bucket extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:tensorflow.metadata.v0.RankHistogram.Bucket)
      BucketOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Bucket.newBuilder() to construct.
    private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Bucket() {
      label_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Bucket();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Bucket(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {

              lowRank_ = input.readUInt64();
              break;
            }
            case 16: {

              highRank_ = input.readUInt64();
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 41: {

              sampleCount_ = input.readDouble();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_Bucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_Bucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.tensorflow.metadata.v0.RankHistogram.Bucket.class, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder.class);
    }

    public static final int LOW_RANK_FIELD_NUMBER = 1;
    private long lowRank_;
    /**
     * <pre>
     * The low rank of the bucket, inclusive.
     * </pre>
     *
     * <code>uint64 low_rank = 1;</code>
     * @return The lowRank.
     */
    @java.lang.Override
    public long getLowRank() {
      return lowRank_;
    }

    public static final int HIGH_RANK_FIELD_NUMBER = 2;
    private long highRank_;
    /**
     * <pre>
     * The high rank of the bucket, exclusive.
     * </pre>
     *
     * <code>uint64 high_rank = 2;</code>
     * @return The highRank.
     */
    @java.lang.Override
    public long getHighRank() {
      return highRank_;
    }

    public static final int LABEL_FIELD_NUMBER = 4;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * The label for the bucket. Can be used to list or summarize the values in
     * this rank bucket.
     * </pre>
     *
     * <code>string label = 4;</code>
     * @return The label.
     */
    @java.lang.Override
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The label for the bucket. Can be used to list or summarize the values in
     * this rank bucket.
     * </pre>
     *
     * <code>string label = 4;</code>
     * @return The bytes for label.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SAMPLE_COUNT_FIELD_NUMBER = 5;
    private double sampleCount_;
    /**
     * <pre>
     * The number of items in the bucket. Stored as a double to be able to
     * handle weighted histograms.
     * </pre>
     *
     * <code>double sample_count = 5;</code>
     * @return The sampleCount.
     */
    @java.lang.Override
    public double getSampleCount() {
      return sampleCount_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (lowRank_ != 0L) {
        output.writeUInt64(1, lowRank_);
      }
      if (highRank_ != 0L) {
        output.writeUInt64(2, highRank_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, label_);
      }
      if (sampleCount_ != 0D) {
        output.writeDouble(5, sampleCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (lowRank_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, lowRank_);
      }
      if (highRank_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, highRank_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, label_);
      }
      if (sampleCount_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(5, sampleCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.tensorflow.metadata.v0.RankHistogram.Bucket)) {
        return super.equals(obj);
      }
      org.tensorflow.metadata.v0.RankHistogram.Bucket other = (org.tensorflow.metadata.v0.RankHistogram.Bucket) obj;

      if (getLowRank()
          != other.getLowRank()) return false;
      if (getHighRank()
          != other.getHighRank()) return false;
      if (!getLabel()
          .equals(other.getLabel())) return false;
      if (java.lang.Double.doubleToLongBits(getSampleCount())
          != java.lang.Double.doubleToLongBits(
              other.getSampleCount())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOW_RANK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getLowRank());
      hash = (37 * hash) + HIGH_RANK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getHighRank());
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + SAMPLE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSampleCount()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.tensorflow.metadata.v0.RankHistogram.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.tensorflow.metadata.v0.RankHistogram.Bucket prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Each bucket defines its start and end ranks along with its count.
     * </pre>
     *
     * Protobuf type {@code tensorflow.metadata.v0.RankHistogram.Bucket}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:tensorflow.metadata.v0.RankHistogram.Bucket)
        org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_Bucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_Bucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.tensorflow.metadata.v0.RankHistogram.Bucket.class, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder.class);
      }

      // Construct using org.tensorflow.metadata.v0.RankHistogram.Bucket.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        lowRank_ = 0L;

        highRank_ = 0L;

        label_ = "";

        sampleCount_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_Bucket_descriptor;
      }

      @java.lang.Override
      public org.tensorflow.metadata.v0.RankHistogram.Bucket getDefaultInstanceForType() {
        return org.tensorflow.metadata.v0.RankHistogram.Bucket.getDefaultInstance();
      }

      @java.lang.Override
      public org.tensorflow.metadata.v0.RankHistogram.Bucket build() {
        org.tensorflow.metadata.v0.RankHistogram.Bucket result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.tensorflow.metadata.v0.RankHistogram.Bucket buildPartial() {
        org.tensorflow.metadata.v0.RankHistogram.Bucket result = new org.tensorflow.metadata.v0.RankHistogram.Bucket(this);
        result.lowRank_ = lowRank_;
        result.highRank_ = highRank_;
        result.label_ = label_;
        result.sampleCount_ = sampleCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.tensorflow.metadata.v0.RankHistogram.Bucket) {
          return mergeFrom((org.tensorflow.metadata.v0.RankHistogram.Bucket)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.tensorflow.metadata.v0.RankHistogram.Bucket other) {
        if (other == org.tensorflow.metadata.v0.RankHistogram.Bucket.getDefaultInstance()) return this;
        if (other.getLowRank() != 0L) {
          setLowRank(other.getLowRank());
        }
        if (other.getHighRank() != 0L) {
          setHighRank(other.getHighRank());
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (other.getSampleCount() != 0D) {
          setSampleCount(other.getSampleCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.tensorflow.metadata.v0.RankHistogram.Bucket parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.tensorflow.metadata.v0.RankHistogram.Bucket) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long lowRank_ ;
      /**
       * <pre>
       * The low rank of the bucket, inclusive.
       * </pre>
       *
       * <code>uint64 low_rank = 1;</code>
       * @return The lowRank.
       */
      @java.lang.Override
      public long getLowRank() {
        return lowRank_;
      }
      /**
       * <pre>
       * The low rank of the bucket, inclusive.
       * </pre>
       *
       * <code>uint64 low_rank = 1;</code>
       * @param value The lowRank to set.
       * @return This builder for chaining.
       */
      public Builder setLowRank(long value) {
        
        lowRank_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The low rank of the bucket, inclusive.
       * </pre>
       *
       * <code>uint64 low_rank = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearLowRank() {
        
        lowRank_ = 0L;
        onChanged();
        return this;
      }

      private long highRank_ ;
      /**
       * <pre>
       * The high rank of the bucket, exclusive.
       * </pre>
       *
       * <code>uint64 high_rank = 2;</code>
       * @return The highRank.
       */
      @java.lang.Override
      public long getHighRank() {
        return highRank_;
      }
      /**
       * <pre>
       * The high rank of the bucket, exclusive.
       * </pre>
       *
       * <code>uint64 high_rank = 2;</code>
       * @param value The highRank to set.
       * @return This builder for chaining.
       */
      public Builder setHighRank(long value) {
        
        highRank_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The high rank of the bucket, exclusive.
       * </pre>
       *
       * <code>uint64 high_rank = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearHighRank() {
        
        highRank_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <pre>
       * The label for the bucket. Can be used to list or summarize the values in
       * this rank bucket.
       * </pre>
       *
       * <code>string label = 4;</code>
       * @return The label.
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The label for the bucket. Can be used to list or summarize the values in
       * this rank bucket.
       * </pre>
       *
       * <code>string label = 4;</code>
       * @return The bytes for label.
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The label for the bucket. Can be used to list or summarize the values in
       * this rank bucket.
       * </pre>
       *
       * <code>string label = 4;</code>
       * @param value The label to set.
       * @return This builder for chaining.
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The label for the bucket. Can be used to list or summarize the values in
       * this rank bucket.
       * </pre>
       *
       * <code>string label = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The label for the bucket. Can be used to list or summarize the values in
       * this rank bucket.
       * </pre>
       *
       * <code>string label = 4;</code>
       * @param value The bytes for label to set.
       * @return This builder for chaining.
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private double sampleCount_ ;
      /**
       * <pre>
       * The number of items in the bucket. Stored as a double to be able to
       * handle weighted histograms.
       * </pre>
       *
       * <code>double sample_count = 5;</code>
       * @return The sampleCount.
       */
      @java.lang.Override
      public double getSampleCount() {
        return sampleCount_;
      }
      /**
       * <pre>
       * The number of items in the bucket. Stored as a double to be able to
       * handle weighted histograms.
       * </pre>
       *
       * <code>double sample_count = 5;</code>
       * @param value The sampleCount to set.
       * @return This builder for chaining.
       */
      public Builder setSampleCount(double value) {
        
        sampleCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The number of items in the bucket. Stored as a double to be able to
       * handle weighted histograms.
       * </pre>
       *
       * <code>double sample_count = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearSampleCount() {
        
        sampleCount_ = 0D;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:tensorflow.metadata.v0.RankHistogram.Bucket)
    }

    // @@protoc_insertion_point(class_scope:tensorflow.metadata.v0.RankHistogram.Bucket)
    private static final org.tensorflow.metadata.v0.RankHistogram.Bucket DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.tensorflow.metadata.v0.RankHistogram.Bucket();
    }

    public static org.tensorflow.metadata.v0.RankHistogram.Bucket getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bucket>
        PARSER = new com.google.protobuf.AbstractParser<Bucket>() {
      @java.lang.Override
      public Bucket parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Bucket(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Bucket> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bucket> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.RankHistogram.Bucket getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int BUCKETS_FIELD_NUMBER = 1;
  private java.util.List<org.tensorflow.metadata.v0.RankHistogram.Bucket> buckets_;
  /**
   * <pre>
   * A list of buckets in the histogram, sorted from lowest-ranked bucket to
   * highest-ranked bucket.
   * </pre>
   *
   * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<org.tensorflow.metadata.v0.RankHistogram.Bucket> getBucketsList() {
    return buckets_;
  }
  /**
   * <pre>
   * A list of buckets in the histogram, sorted from lowest-ranked bucket to
   * highest-ranked bucket.
   * </pre>
   *
   * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder> 
      getBucketsOrBuilderList() {
    return buckets_;
  }
  /**
   * <pre>
   * A list of buckets in the histogram, sorted from lowest-ranked bucket to
   * highest-ranked bucket.
   * </pre>
   *
   * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public int getBucketsCount() {
    return buckets_.size();
  }
  /**
   * <pre>
   * A list of buckets in the histogram, sorted from lowest-ranked bucket to
   * highest-ranked bucket.
   * </pre>
   *
   * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public org.tensorflow.metadata.v0.RankHistogram.Bucket getBuckets(int index) {
    return buckets_.get(index);
  }
  /**
   * <pre>
   * A list of buckets in the histogram, sorted from lowest-ranked bucket to
   * highest-ranked bucket.
   * </pre>
   *
   * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder getBucketsOrBuilder(
      int index) {
    return buckets_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * An optional descriptive name of the histogram, to be used for labeling.
   * </pre>
   *
   * <code>string name = 2;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * An optional descriptive name of the histogram, to be used for labeling.
   * </pre>
   *
   * <code>string name = 2;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < buckets_.size(); i++) {
      output.writeMessage(1, buckets_.get(i));
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < buckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, buckets_.get(i));
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.tensorflow.metadata.v0.RankHistogram)) {
      return super.equals(obj);
    }
    org.tensorflow.metadata.v0.RankHistogram other = (org.tensorflow.metadata.v0.RankHistogram) obj;

    if (!getBucketsList()
        .equals(other.getBucketsList())) return false;
    if (!getName()
        .equals(other.getName())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBucketsCount() > 0) {
      hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketsList().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.metadata.v0.RankHistogram parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.tensorflow.metadata.v0.RankHistogram prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * The data used to create a rank histogram of a non-numeric feature of a
   * dataset. The rank of a value in a feature can be used as a measure of how
   * commonly the value is found in the entire dataset. With bucket sizes of one,
   * this becomes a distribution function of all feature values.
   * </pre>
   *
   * Protobuf type {@code tensorflow.metadata.v0.RankHistogram}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:tensorflow.metadata.v0.RankHistogram)
      org.tensorflow.metadata.v0.RankHistogramOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.tensorflow.metadata.v0.RankHistogram.class, org.tensorflow.metadata.v0.RankHistogram.Builder.class);
    }

    // Construct using org.tensorflow.metadata.v0.RankHistogram.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getBucketsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        bucketsBuilder_.clear();
      }
      name_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.tensorflow.metadata.v0.Statistics.internal_static_tensorflow_metadata_v0_RankHistogram_descriptor;
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.RankHistogram getDefaultInstanceForType() {
      return org.tensorflow.metadata.v0.RankHistogram.getDefaultInstance();
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.RankHistogram build() {
      org.tensorflow.metadata.v0.RankHistogram result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.tensorflow.metadata.v0.RankHistogram buildPartial() {
      org.tensorflow.metadata.v0.RankHistogram result = new org.tensorflow.metadata.v0.RankHistogram(this);
      int from_bitField0_ = bitField0_;
      if (bucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          buckets_ = java.util.Collections.unmodifiableList(buckets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.buckets_ = buckets_;
      } else {
        result.buckets_ = bucketsBuilder_.build();
      }
      result.name_ = name_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof org.tensorflow.metadata.v0.RankHistogram) {
        return mergeFrom((org.tensorflow.metadata.v0.RankHistogram)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.tensorflow.metadata.v0.RankHistogram other) {
      if (other == org.tensorflow.metadata.v0.RankHistogram.getDefaultInstance()) return this;
      if (bucketsBuilder_ == null) {
        if (!other.buckets_.isEmpty()) {
          if (buckets_.isEmpty()) {
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBucketsIsMutable();
            buckets_.addAll(other.buckets_);
          }
          onChanged();
        }
      } else {
        if (!other.buckets_.isEmpty()) {
          if (bucketsBuilder_.isEmpty()) {
            bucketsBuilder_.dispose();
            bucketsBuilder_ = null;
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            bucketsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getBucketsFieldBuilder() : null;
          } else {
            bucketsBuilder_.addAllMessages(other.buckets_);
          }
        }
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.tensorflow.metadata.v0.RankHistogram parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.tensorflow.metadata.v0.RankHistogram) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<org.tensorflow.metadata.v0.RankHistogram.Bucket> buckets_ =
      java.util.Collections.emptyList();
    private void ensureBucketsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        buckets_ = new java.util.ArrayList<org.tensorflow.metadata.v0.RankHistogram.Bucket>(buckets_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.tensorflow.metadata.v0.RankHistogram.Bucket, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder, org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder> bucketsBuilder_;

    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public java.util.List<org.tensorflow.metadata.v0.RankHistogram.Bucket> getBucketsList() {
      if (bucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buckets_);
      } else {
        return bucketsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public int getBucketsCount() {
      if (bucketsBuilder_ == null) {
        return buckets_.size();
      } else {
        return bucketsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public org.tensorflow.metadata.v0.RankHistogram.Bucket getBuckets(int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(
        int index, org.tensorflow.metadata.v0.RankHistogram.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.set(index, value);
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(
        int index, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(org.tensorflow.metadata.v0.RankHistogram.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(
        int index, org.tensorflow.metadata.v0.RankHistogram.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(index, value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(
        org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(
        int index, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder addAllBuckets(
        java.lang.Iterable<? extends org.tensorflow.metadata.v0.RankHistogram.Bucket> values) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, buckets_);
        onChanged();
      } else {
        bucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder clearBuckets() {
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        bucketsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public Builder removeBuckets(int index) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.remove(index);
        onChanged();
      } else {
        bucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder getBucketsBuilder(
        int index) {
      return getBucketsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder getBucketsOrBuilder(
        int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);  } else {
        return bucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public java.util.List<? extends org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder> 
         getBucketsOrBuilderList() {
      if (bucketsBuilder_ != null) {
        return bucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buckets_);
      }
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder addBucketsBuilder() {
      return getBucketsFieldBuilder().addBuilder(
          org.tensorflow.metadata.v0.RankHistogram.Bucket.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder addBucketsBuilder(
        int index) {
      return getBucketsFieldBuilder().addBuilder(
          index, org.tensorflow.metadata.v0.RankHistogram.Bucket.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of buckets in the histogram, sorted from lowest-ranked bucket to
     * highest-ranked bucket.
     * </pre>
     *
     * <code>repeated .tensorflow.metadata.v0.RankHistogram.Bucket buckets = 1;</code>
     */
    public java.util.List<org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder> 
         getBucketsBuilderList() {
      return getBucketsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.tensorflow.metadata.v0.RankHistogram.Bucket, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder, org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder> 
        getBucketsFieldBuilder() {
      if (bucketsBuilder_ == null) {
        bucketsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.tensorflow.metadata.v0.RankHistogram.Bucket, org.tensorflow.metadata.v0.RankHistogram.Bucket.Builder, org.tensorflow.metadata.v0.RankHistogram.BucketOrBuilder>(
                buckets_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        buckets_ = null;
      }
      return bucketsBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * An optional descriptive name of the histogram, to be used for labeling.
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * An optional descriptive name of the histogram, to be used for labeling.
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * An optional descriptive name of the histogram, to be used for labeling.
     * </pre>
     *
     * <code>string name = 2;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * An optional descriptive name of the histogram, to be used for labeling.
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * An optional descriptive name of the histogram, to be used for labeling.
     * </pre>
     *
     * <code>string name = 2;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:tensorflow.metadata.v0.RankHistogram)
  }

  // @@protoc_insertion_point(class_scope:tensorflow.metadata.v0.RankHistogram)
  private static final org.tensorflow.metadata.v0.RankHistogram DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.tensorflow.metadata.v0.RankHistogram();
  }

  public static org.tensorflow.metadata.v0.RankHistogram getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RankHistogram>
      PARSER = new com.google.protobuf.AbstractParser<RankHistogram>() {
    @java.lang.Override
    public RankHistogram parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new RankHistogram(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<RankHistogram> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RankHistogram> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.tensorflow.metadata.v0.RankHistogram getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

