/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser.impl;

import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.chain.node.LlmNode;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.Tinyflow;
import dev.tinyflow.core.parser.BaseNodeParser;
import dev.tinyflow.core.provider.LlmProvider;
import java.util.List;

public class LlmNodeParser
extends BaseNodeParser {
    @Override
    public BaseNode doParse(JSONObject root, JSONObject data, Tinyflow tinyflow) {
        LlmNode llmNode = new LlmNode();
        llmNode.setUserPrompt(data.getString("userPrompt"));
        llmNode.setSystemPrompt(data.getString("systemPrompt"));
        llmNode.setOutType(data.getString("outType"));
        ChatOptions chatOptions = new ChatOptions();
        chatOptions.setTopK(Integer.valueOf(data.containsKey((Object)"topK") ? data.getInteger("topK") : 10));
        chatOptions.setTopP(Float.valueOf(data.containsKey((Object)"topP") ? data.getFloat("topP").floatValue() : 0.8f));
        chatOptions.setTemperature(Float.valueOf(data.containsKey((Object)"temperature") ? data.getFloat("temperature").floatValue() : 0.8f));
        llmNode.setChatOptions(chatOptions);
        LlmProvider llmProvider = tinyflow.getLlmProvider();
        if (llmProvider != null) {
            Llm llm = llmProvider.getLlm(data.getString("llmId"));
            llmNode.setLlm(llm);
        }
        List<Parameter> files = this.getParameters(data, "images");
        llmNode.setImages(files);
        return llmNode;
    }
}

