/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.script;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.antons.script.Fs;

public class FindMains {
    private List<String> mains = new ArrayList<String>();
    private Pattern pattern = Pattern.compile("\n *public +static [^\n]* main *\\(");

    public static FindMains instance() {
        return new FindMains();
    }

    public void find(String path) {
        File f = new File(path);
        this.find(f, f.getAbsolutePath());
    }

    private void find(File file, String root) {
        if (file.isFile()) {
            String text;
            Matcher matcher;
            String name = file.getName();
            if (name.endsWith(".java") && (matcher = this.pattern.matcher(text = Fs.readTextFile(file.getAbsolutePath(), "utf-8"))).find()) {
                String pcg = file.getAbsolutePath();
                pcg = pcg.substring(root.length() + 1, pcg.length() - 5);
                pcg = pcg.replace('/', '.');
                pcg = pcg.replace('\\', '.');
                this.mains.add(pcg);
            }
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.find(child, root);
                }
            }
        }
    }

    public List<String> mains() {
        return this.mains;
    }
}

