/*
 * Decompiled with CFR 0.152.
 */
package io.github.codert96.orm.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.github.codert96.orm.config.Configuration;
import io.github.codert96.orm.core.ColumnFunction;
import io.github.codert96.orm.core.ColumnInfo;
import io.github.codert96.orm.core.LikePatten;
import io.github.codert96.orm.core.Page;
import io.github.codert96.orm.utils.Utils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.NonNull;
import org.springframework.util.StopWatch;

public class Example<DTO, T>
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Example.class);
    private static final long serialVersionUID = 1L;
    private static NamedParameterJdbcOperations namedParameterJdbcOperations;
    private static ObjectMapper objectMapper;
    private final DTO dto;
    private final Class<T> resultClass;
    private final List<String> firstExpressions = new ArrayList<String>();
    private final List<String> selectExpressions = new ArrayList<String>();
    private final List<String> whereExpressions = new ArrayList<String>();
    private final List<String> lastExpressions = new ArrayList<String>();
    private boolean useBefore = true;
    private boolean useAfter = true;
    private String tableName;
    private final List<Consumer<Example<DTO, ?>>> beforeQuery = new ArrayList();
    private final List<Consumer<List<?>>> afterQuery = new ArrayList();

    public static <DTO, T> Example<DTO, T> of(@NonNull DTO dto, @NonNull Class<T> entityClass) {
        Utils.extract(entityClass);
        return new Example<DTO, T>(dto, entityClass).setTableName(Utils.extractTableName(entityClass));
    }

    public final Example<DTO, T> first(String ... first) {
        this.firstExpressions.addAll(Arrays.asList(first));
        return this;
    }

    public final Example<DTO, T> last(String ... last) {
        this.lastExpressions.addAll(Arrays.asList(last));
        return this;
    }

    public final Example<DTO, T> select(String ... columns) {
        this.selectExpressions.addAll(Arrays.asList(columns));
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> select(ColumnFunction<DTO, R> ... columns) {
        this.selectExpressions.addAll(Stream.of(columns).map(Utils::extractColumn).map(ColumnInfo::getColumnName).toList());
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> eq(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, "=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> ne(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, "<>", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> le(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, "<=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> ge(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, ">=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> lt(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, "<", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> gt(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        return this.operator(ignoreNull, ">", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> eq(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, "=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> ne(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, "<>", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> le(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, "<=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> ge(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, ">=", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> lt(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, "<", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> gt(ColumnFunction<DTO, R> ... columns) {
        return this.operator(false, ">", columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> in(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        for (ColumnFunction<DTO, R> column : columns) {
            if (ignoreNull && Utils.isIgnore(this.dto, column)) continue;
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add("%s IN (:%s)".formatted(columnInfo.getColumnName(), columnInfo.getFieldName()));
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> in(ColumnFunction<DTO, R> ... columns) {
        return this.in(false, columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> notIn(boolean ignoreNull, ColumnFunction<DTO, R> ... columns) {
        for (ColumnFunction<DTO, R> column : columns) {
            if (ignoreNull && Utils.isIgnore(this.dto, column)) continue;
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add("%s NOT IN (:%s)".formatted(columnInfo.getColumnName(), columnInfo.getFieldName()));
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> isNull(ColumnFunction<DTO, R> ... columns) {
        for (ColumnFunction<DTO, R> column : columns) {
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add("%s IS NULL".formatted(columnInfo.getColumnName()));
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> isNotNull(ColumnFunction<DTO, R> ... columns) {
        for (ColumnFunction<DTO, R> column : columns) {
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add("%s IS NOT NULL".formatted(columnInfo.getColumnName()));
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> notIn(ColumnFunction<DTO, R> ... columns) {
        return this.notIn(false, columns);
    }

    public final <R> Example<DTO, T> notBetween(ColumnFunction<DTO, R> column, ColumnFunction<DTO, R> first, ColumnFunction<DTO, R> last) {
        return this.notBetween(false, column, first, last);
    }

    public final <R> Example<DTO, T> notBetween(boolean ignoreNull, ColumnFunction<DTO, R> column, ColumnFunction<DTO, R> first, ColumnFunction<DTO, R> last) {
        boolean firstIgnore = Utils.isIgnore(this.dto, first);
        boolean lastIgnore = Utils.isIgnore(this.dto, last);
        ColumnInfo columnInfo = Utils.extractColumn(column);
        if (ignoreNull && firstIgnore && lastIgnore) {
            return this;
        }
        if (!firstIgnore && !lastIgnore) {
            return this.apply("%s NOT BETWEEN {0} AND {1}".formatted(columnInfo.getColumnName()), first, last);
        }
        if (!firstIgnore) {
            return this.apply("%s < {0}".formatted(columnInfo.getColumnName()), first);
        }
        if (!lastIgnore) {
            return this.apply("%s > {0}".formatted(columnInfo.getColumnName()), last);
        }
        return this;
    }

    public final <R> Example<DTO, T> between(ColumnFunction<DTO, R> column, ColumnFunction<DTO, R> first, ColumnFunction<DTO, R> last) {
        return this.between(false, column, first, last);
    }

    public final <R> Example<DTO, T> between(boolean ignoreNull, ColumnFunction<DTO, R> column, ColumnFunction<DTO, R> first, ColumnFunction<DTO, R> last) {
        boolean firstIgnore = Utils.isIgnore(this.dto, first);
        boolean lastIgnore = Utils.isIgnore(this.dto, last);
        ColumnInfo columnInfo = Utils.extractColumn(column);
        if (ignoreNull && firstIgnore && lastIgnore) {
            return this;
        }
        if (!firstIgnore && !lastIgnore) {
            return this.apply("%s BETWEEN {0} AND {1}".formatted(columnInfo.getColumnName()), first, last);
        }
        if (!firstIgnore) {
            return this.apply("%s >= {0}".formatted(columnInfo.getColumnName()), first);
        }
        if (!lastIgnore) {
            return this.apply("%s <= {0}".formatted(columnInfo.getColumnName()), last);
        }
        return this;
    }

    public final Example<DTO, T> or(Consumer<Example<DTO, T>> consumer) {
        return this.apply("OR", consumer);
    }

    public final Example<DTO, T> and(Consumer<Example<DTO, T>> consumer) {
        return this.apply("AND", consumer);
    }

    private Example<DTO, T> apply(String str, Consumer<Example<DTO, T>> consumer) {
        Example<DTO, T> example = new Example<DTO, T>(this.dto, this.resultClass);
        consumer.accept(example);
        String where = example.toWhere();
        if (!example.whereExpressions.isEmpty()) {
            if (example.whereExpressions.size() > 1) {
                this.whereExpressions.add(" %s (%s)".formatted(str, where));
            } else {
                this.whereExpressions.add(" %s %s".formatted(str, where));
            }
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> like(ColumnFunction<DTO, R> ... columns) {
        return this.like(false, false, LikePatten.LIKE, columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> like(boolean notLike, LikePatten patten, ColumnFunction<DTO, R> ... columns) {
        return this.like(false, notLike, patten, columns);
    }

    @SafeVarargs
    public final <R> Example<DTO, T> like(boolean ignoreNull, boolean notLike, LikePatten patten, ColumnFunction<DTO, R> ... columns) {
        for (ColumnFunction<DTO, R> column : columns) {
            if (ignoreNull && Utils.isIgnore(this.dto, column)) continue;
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add("%s %sLIKE ".concat(patten.patten).formatted(columnInfo.getColumnName(), notLike ? "NOT " : "", columnInfo.getFieldName()));
        }
        return this;
    }

    @SafeVarargs
    public final <R> Example<DTO, T> apply(String sqlCorn, ColumnFunction<DTO, R> ... columns) {
        Object[] array = Arrays.stream(columns).map(Utils::extractColumn).map(columnInfo -> ":%s".formatted(columnInfo.getFieldName())).toArray();
        this.whereExpressions.add(MessageFormat.format(sqlCorn, array));
        return this;
    }

    @SafeVarargs
    private <R> Example<DTO, T> operator(boolean ignoreNull, String operator, ColumnFunction<DTO, R> ... columns) {
        MessageFormat format = new MessageFormat("{0} {1} :{2}");
        for (ColumnFunction<DTO, R> column : columns) {
            if (ignoreNull && Utils.isIgnore(this.dto, column)) continue;
            ColumnInfo columnInfo = Utils.extractColumn(column);
            this.whereExpressions.add(format.format(new Object[]{columnInfo.getColumnName(), operator, columnInfo.getFieldName()}));
        }
        return this;
    }

    public Example<DTO, T> beforeQuery(Consumer<Example<DTO, ?>> consumer) {
        this.beforeQuery.add(consumer);
        return this;
    }

    public Example<DTO, T> afterQuery(Consumer<List<?>> consumer) {
        this.afterQuery.add(consumer);
        return this;
    }

    public Example<DTO, T> clearFirst() {
        this.firstExpressions.clear();
        return this;
    }

    public Example<DTO, T> clearLast() {
        this.lastExpressions.clear();
        return this;
    }

    public Example<DTO, T> clearSelect() {
        this.selectExpressions.clear();
        return this;
    }

    public Example<DTO, T> clearWhere() {
        this.whereExpressions.clear();
        return this;
    }

    public Example<DTO, T> clearBefore() {
        this.beforeQuery.clear();
        return this;
    }

    public Example<DTO, T> clearAfter() {
        this.lastExpressions.clear();
        return this;
    }

    private String toWhere() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.whereExpressions.size(); ++i) {
            String s = this.whereExpressions.get(i);
            if (s.startsWith(" AND ") || s.startsWith(" OR ")) {
                if (i == 0) {
                    stringBuilder.append(s.replaceFirst("^ AND |^ OR ", ""));
                    continue;
                }
                String string = stringBuilder.toString();
                stringBuilder.setLength(0);
                stringBuilder.append("(%s)".formatted(string)).append(s);
                continue;
            }
            if (i != 0) {
                stringBuilder.append(" AND ").append(s);
                continue;
            }
            stringBuilder.append(s);
        }
        return stringBuilder.toString().trim();
    }

    public Long count() {
        return this.count("1");
    }

    public Long count(String column) {
        Class rawClass = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Long.class).getRawClass();
        Example example = this.copy(rawClass);
        List query = example.clearSelect().select("COUNT(%s) AS count_number".formatted(column)).list();
        if (query.isEmpty()) {
            return 0L;
        }
        Map map = (Map)query.get(0);
        return map.getOrDefault("count_number", 0L);
    }

    public Page<T> page(Page<T> page) {
        Long count = this.copy().setUseAfter(false).count("1");
        page.setTotal(count);
        if (Objects.equals(0L, count)) {
            return page;
        }
        long offset = (page.getCurrent() - 1L) * page.getSize();
        this.last("LIMIT %s OFFSET %s".formatted(page.getSize(), offset));
        List<T> query = this.list();
        page.setRecords(query);
        return page;
    }

    public List<T> list() {
        if (this.useBefore) {
            Configuration.BEFORE_QUERY.forEach(consumer -> consumer.accept(this, this.resultClass));
            this.beforeQuery.forEach(consumer -> consumer.accept(this));
        }
        StringJoiner execSql = new StringJoiner(" ");
        if (!this.firstExpressions.isEmpty()) {
            execSql.add(String.join((CharSequence)System.lineSeparator(), this.firstExpressions));
        }
        execSql.add("SELECT");
        if (this.selectExpressions.isEmpty()) {
            List<String> extract = Utils.extract(this.resultClass);
            if (extract.isEmpty()) {
                execSql.add("*");
            } else {
                execSql.add(String.join((CharSequence)",", extract));
            }
        } else {
            execSql.add(String.join((CharSequence)System.lineSeparator(), this.selectExpressions));
        }
        execSql.add("FROM").add(this.tableName);
        if (!this.whereExpressions.isEmpty()) {
            execSql.add("WHERE").add(this.toWhere());
        }
        if (!this.lastExpressions.isEmpty()) {
            execSql.add(String.join((CharSequence)System.lineSeparator(), this.lastExpressions));
        }
        String sql = execSql.toString();
        StopWatch stopWatch = new StopWatch("\u67e5\u8be2\uff1a%s".formatted(this.tableName));
        stopWatch.start("\u6267\u884cSQL");
        List list = namedParameterJdbcOperations.query(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(this.dto), (RowMapper)new LowerCaseColumnMapRowMapper());
        if (list.isEmpty()) {
            return new ArrayList();
        }
        ArrayList result = (ArrayList)objectMapper.convertValue((Object)list, (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, this.resultClass));
        if (this.useAfter) {
            Configuration.AFTER_QUERY.forEach(consumer -> consumer.accept(result, this.resultClass));
            this.afterQuery.forEach(consumer -> consumer.accept(result));
        }
        stopWatch.stop();
        StringJoiner formatLog = new StringJoiner(System.lineSeparator());
        formatLog.add("").add(stopWatch.prettyPrint(TimeUnit.SECONDS).concat("-".repeat(42))).add(Utils.formatSql(sql, this.dto)).add("-".repeat(42)).add("query result size: " + result.size()).add("-".repeat(42));
        log.debug(formatLog.toString());
        return result;
    }

    public Example<DTO, T> copy() {
        return this.copy(this.resultClass);
    }

    public <R> Example<DTO, R> copy(Class<R> resultClass) {
        Example<DTO, R> copy = new Example<DTO, R>(this.dto, resultClass);
        copy.firstExpressions.addAll(this.firstExpressions);
        copy.lastExpressions.addAll(this.lastExpressions);
        copy.selectExpressions.addAll(this.selectExpressions);
        copy.whereExpressions.addAll(this.whereExpressions);
        copy.beforeQuery.addAll(this.beforeQuery);
        copy.afterQuery.addAll(this.afterQuery);
        copy.useBefore = this.useBefore;
        copy.useAfter = this.useAfter;
        copy.tableName = this.tableName;
        return copy;
    }

    public String toString() {
        return this.toWhere();
    }

    @Generated
    private Example(DTO dto, Class<T> resultClass) {
        this.dto = dto;
        this.resultClass = resultClass;
    }

    @Generated
    public static void setNamedParameterJdbcOperations(NamedParameterJdbcOperations namedParameterJdbcOperations) {
        Example.namedParameterJdbcOperations = namedParameterJdbcOperations;
    }

    @Generated
    public static void setObjectMapper(ObjectMapper objectMapper) {
        Example.objectMapper = objectMapper;
    }

    @Generated
    public Example<DTO, T> setUseBefore(boolean useBefore) {
        this.useBefore = useBefore;
        return this;
    }

    @Generated
    public Example<DTO, T> setUseAfter(boolean useAfter) {
        this.useAfter = useAfter;
        return this;
    }

    @Generated
    private Example<DTO, T> setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public static class LowerCaseColumnMapRowMapper
    extends ColumnMapRowMapper {
        protected String getColumnKey(String columnName) {
            return columnName.toLowerCase();
        }
    }
}

