/*
 * Decompiled with CFR 0.152.
 */
package io.github.codert96.orm.utils;

import io.github.codert96.orm.core.ColumnFunction;
import io.github.codert96.orm.core.ColumnInfo;
import jakarta.persistence.Column;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class Utils {
    private static final Map<String, Map<String, ColumnInfo>> classCache = new ConcurrentHashMap<String, Map<String, ColumnInfo>>();
    private static final Map<Class<?>, String> tableNameCache = new ConcurrentHashMap();

    public static <DTO> SerializedLambda extract(ColumnFunction<DTO, ?> function) {
        Method writeReplace = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        writeReplace.setAccessible(true);
        return (SerializedLambda)writeReplace.invoke(function, new Object[0]);
    }

    public static String extractFieldName(SerializedLambda lambda) {
        return Utils.extractFieldName(lambda.getImplMethodName());
    }

    public static String extractFieldName(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u65b9\u6cd5\u540d: %s".formatted(methodName));
    }

    public static <DTO> ColumnInfo extractColumn(ColumnFunction<DTO, ?> function) {
        SerializedLambda serializedLambda = Utils.extract(function);
        return Utils.cache(ClassUtils.forName((String)serializedLambda.getImplClass().replace("/", "."), null), serializedLambda.getImplMethodName());
    }

    private static ColumnInfo cache(Class<?> clazz, String method) {
        String extractedTableName = Utils.extractTableName(clazz);
        return classCache.computeIfAbsent(clazz.getName(), className -> Collections.synchronizedMap(new LinkedHashMap())).computeIfAbsent(method, methodName -> {
            ColumnInfo columnInfo = new ColumnInfo();
            String fieldName = Utils.extractFieldName(methodName);
            Field declaredField = ReflectionUtils.findField((Class)clazz, (String)fieldName);
            if (Objects.isNull(declaredField)) {
                return null;
            }
            columnInfo.setFieldName(fieldName);
            columnInfo.setColumnName(JdbcUtils.convertPropertyNameToUnderscoreName((String)fieldName));
            columnInfo.setTableName(extractedTableName);
            ReflectionUtils.makeAccessible((Field)declaredField);
            if (declaredField.isAnnotationPresent(Transient.class) && Modifier.isTransient(declaredField.getModifiers())) {
                return null;
            }
            if (declaredField.isAnnotationPresent(Column.class)) {
                String tableName;
                Column column = declaredField.getAnnotation(Column.class);
                String columnName = column.name();
                if (!StringUtils.hasText((String)columnName)) {
                    columnName = JdbcUtils.convertPropertyNameToUnderscoreName((String)fieldName);
                }
                if (StringUtils.hasText((String)(tableName = column.table()))) {
                    columnInfo.setTableName(tableName);
                }
                columnInfo.setColumnName(columnName);
                columnInfo.setInsertable(columnInfo.isInsertable());
                columnInfo.setUpdatable(columnInfo.isUpdatable());
            }
            return columnInfo;
        });
    }

    public static String extractTableName(Class<?> clazz) {
        return tableNameCache.computeIfAbsent(clazz, tmp -> {
            String simpleName = tmp.getSimpleName();
            AtomicReference<String> tableNameRef = new AtomicReference<String>(JdbcUtils.convertPropertyNameToUnderscoreName((String)simpleName));
            if (clazz.isAnnotationPresent(Table.class)) {
                Table table = clazz.getAnnotation(Table.class);
                String name = table.name();
                String schema = table.schema();
                if (StringUtils.hasText((String)name)) {
                    tableNameRef.set(name);
                    if (StringUtils.hasText((String)schema)) {
                        tableNameRef.set("%s.%s".formatted(schema, name));
                    }
                }
            }
            return tableNameRef.get();
        });
    }

    public static List<String> extract(Class<?> clazz) {
        String clazzName = clazz.getName();
        if (!classCache.containsKey(clazzName)) {
            PropertyDescriptor[] beanProperties = ReflectUtils.getBeanProperties(clazz);
            Stream.of(clazz.getMethods()).filter(method -> Objects.equals(method.getParameterCount(), 0)).map(Method::getName).filter(method -> method.startsWith("get") || method.startsWith("is")).sorted().toList().forEach(string -> Utils.cache(clazz, string));
        }
        return classCache.getOrDefault(clazzName, Map.of()).values().stream().filter(Objects::nonNull).map(ColumnInfo::getColumnName).filter(StringUtils::hasText).toList();
    }

    public static <DTO, R> boolean isIgnore(DTO dto, ColumnFunction<DTO, R> columnFunction) {
        Object apply = columnFunction.apply(dto);
        if (Objects.isNull(apply)) {
            return true;
        }
        if (apply instanceof String) {
            String string = (String)apply;
            return string.isEmpty();
        }
        if (apply instanceof Collection) {
            Collection collection = (Collection)apply;
            return collection.isEmpty();
        }
        if (apply instanceof Map) {
            Map map = (Map)apply;
            return map.isEmpty();
        }
        return false;
    }

    public static String formatSql(String sql, Object args) {
        Field[] declaredFields;
        Class<?> clazz = args.getClass();
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            String fieldName = ":%s".formatted(declaredField.getName());
            if (!sql.contains(fieldName)) continue;
            ReflectionUtils.makeAccessible((Field)declaredField);
            Object data = ReflectionUtils.getField((Field)declaredField, (Object)args);
            sql = Objects.isNull(data) ? sql.replace(fieldName, "null") : sql.replace(fieldName, "'%s'".formatted(data));
        }
        return sql;
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface Func<T, R>
    extends Function<T, R> {
        @Override
        default public R apply(T t) {
            try {
                return this.exec(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public R exec(T var1) throws Exception;
    }
}

