/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.app.dropwizard.v2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.app.dropwizard.v2.proto.ProtobufBundle;
import io.github.devlibx.easy.metrics.prometheus.PrometheusMetrics;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import javax.servlet.Servlet;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseApplication<T extends Configuration>
extends Application<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseApplication.class);

    public void initialize(Bootstrap<T> bootstrap) {
        super.initialize(bootstrap);
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
        if (this.enableProtobufSupport()) {
            bootstrap.addBundle(new ProtobufBundle());
        }
    }

    public void run(T t, Environment environment) throws Exception {
        environment.getObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    protected void registerPrometheus(Environment environment) {
        IMetrics metrics = null;
        try {
            metrics = (IMetrics)ApplicationContext.getInstance(IMetrics.class);
        }
        catch (Exception e) {
            log.error("Failed to registered prometheus - IMetrics instance is not found");
        }
        if (metrics instanceof PrometheusMetrics) {
            try {
                CollectorRegistry collectorRegistry = (CollectorRegistry)metrics.getRegistry(CollectorRegistry.class);
                collectorRegistry.register((Collector)new DropwizardExports(environment.metrics()));
                environment.servlets().addServlet("prometheusMetrics", (Servlet)new MetricsServlet(collectorRegistry)).addMapping(new String[]{"/metrics"});
            }
            catch (IMetrics.InvalidRegistryTypeFoundException e) {
                log.error("Failed to registered prometheus - registry type mus be CollectorRegistry");
            }
            catch (Exception e) {
                log.error("Failed to registered prometheus - unknown error", (Throwable)e);
            }
        } else {
            log.error("Failed to registered prometheus - IMetrics instance is of PrometheusMetrics type");
        }
    }

    protected boolean enableProtobufSupport() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseApplication)) {
            return false;
        }
        BaseApplication other = (BaseApplication)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseApplication;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BaseApplication()";
    }
}

