/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.app.dropwizard.v2.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.setup.Environment;
import io.gitbub.devlibx.easy.helper.healthcheck.IHealthCheckProvider;
import io.gitbub.devlibx.easy.helper.string.StringHelper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHealthCheck {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHealthCheck.class);
    private final Map<String, IHealthCheckProvider> summarizers;
    private final StringHelper stringHelper;

    @Inject
    public ApplicationHealthCheck(Map<String, IHealthCheckProvider> summarizers, StringHelper stringHelper) {
        this.summarizers = summarizers;
        this.stringHelper = stringHelper;
    }

    public void setupHealthChecks(Environment environment) {
        this.healthChecks().forEach(healthCheckHolder -> environment.healthChecks().register(((HealthCheckHolder)healthCheckHolder).name, ((HealthCheckHolder)healthCheckHolder).healthCheck));
    }

    private List<HealthCheckHolder> healthChecks() {
        ArrayList<HealthCheckHolder> list = new ArrayList<HealthCheckHolder>();
        this.summarizers.forEach((name, healthCheckProvider) -> {
            HealthCheck healthCheck = new HealthCheck((IHealthCheckProvider)healthCheckProvider){
                final /* synthetic */ IHealthCheckProvider val$healthCheckProvider;
                {
                    this.val$healthCheckProvider = iHealthCheckProvider;
                }

                protected HealthCheck.Result check() throws Exception {
                    IHealthCheckProvider.Result result = this.val$healthCheckProvider.check();
                    HealthCheck.ResultBuilder rb = HealthCheck.Result.builder();
                    if (result.getDetails() != null) {
                        rb.withDetail("details", (Object)result.getDetails());
                    }
                    if (result.isHealthy()) {
                        rb.healthy().withMessage(result.getMessage());
                    } else {
                        rb.unhealthy().withMessage(result.getMessage());
                    }
                    return rb.build();
                }
            };
            list.add(HealthCheckHolder.builder().healthCheck(healthCheck).name((String)name).build());
        });
        return list;
    }

    public static class HealthCheckHolder {
        private String name;
        private HealthCheck healthCheck;

        HealthCheckHolder(String name, HealthCheck healthCheck) {
            this.name = name;
            this.healthCheck = healthCheck;
        }

        public static HealthCheckHolderBuilder builder() {
            return new HealthCheckHolderBuilder();
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HealthCheckHolder)) {
                return false;
            }
            HealthCheckHolder other = (HealthCheckHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            HealthCheck this$healthCheck = this.getHealthCheck();
            HealthCheck other$healthCheck = other.getHealthCheck();
            return !(this$healthCheck == null ? other$healthCheck != null : !this$healthCheck.equals(other$healthCheck));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HealthCheckHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            HealthCheck $healthCheck = this.getHealthCheck();
            result = result * 59 + ($healthCheck == null ? 43 : $healthCheck.hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationHealthCheck.HealthCheckHolder(name=" + this.getName() + ", healthCheck=" + this.getHealthCheck() + ")";
        }

        public String getName() {
            return this.name;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public static class HealthCheckHolderBuilder {
            private String name;
            private HealthCheck healthCheck;

            HealthCheckHolderBuilder() {
            }

            public HealthCheckHolderBuilder name(String name) {
                this.name = name;
                return this;
            }

            public HealthCheckHolderBuilder healthCheck(HealthCheck healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            public HealthCheckHolder build() {
                return new HealthCheckHolder(this.name, this.healthCheck);
            }

            public String toString() {
                return "ApplicationHealthCheck.HealthCheckHolder.HealthCheckHolderBuilder(name=" + this.name + ", healthCheck=" + this.healthCheck + ")";
            }
        }
    }
}

