/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.ITask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.IValueTask;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.exceptions.TaskException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BaseTask<T>
implements IValueTask<T> {
    protected TaskState _state = TaskState.NOT_EXECUTED;
    protected Throwable _exception;
    protected Runnable _preExecute;
    protected Consumer<T> _onSuccess;
    protected Consumer<Object> _onUpdate;
    protected BiConsumer<T, Boolean> _onComplete;
    protected Function<Throwable, Boolean> _onError;
    private final ITaskExecutor _executor;

    public BaseTask(ITaskExecutor executor) {
        this._executor = executor;
    }

    @Override
    public ITask onExecuted(Runnable onExecuted) {
        this.checkForValidState("alter");
        if (this._preExecute == null) {
            this._preExecute = onExecuted;
        } else {
            Runnable oldPreExecute = this._preExecute;
            this._preExecute = () -> {
                oldPreExecute.run();
                onExecuted.run();
            };
        }
        return this;
    }

    @Override
    public IValueTask<T> onSuccess(Consumer<T> onSuccess) {
        this.checkForValidState("alter");
        this._onSuccess = this._onSuccess == null ? onSuccess : this._onSuccess.andThen(onSuccess);
        return this;
    }

    @Override
    public ITask onUpdate(Consumer<Object> onUpdate) {
        this.checkForValidState("alter");
        this._onUpdate = this._onUpdate == null ? onUpdate : this._onUpdate.andThen(onUpdate);
        return this;
    }

    @Override
    public IValueTask<T> onComplete(BiConsumer<T, Boolean> onComplete) {
        this.checkForValidState("alter");
        this._onComplete = this._onComplete == null ? onComplete : this._onComplete.andThen(onComplete);
        return this;
    }

    @Override
    public ITask onError(Function<Throwable, Boolean> onError) {
        this.checkForValidState("alter");
        if (this._onError == null) {
            this._onError = onError;
        } else {
            Function<Throwable, Boolean> oldOnError = this._onError;
            this._onError = throwable -> {
                oldOnError.apply((Throwable)throwable);
                return (Boolean)onError.apply((Throwable)throwable);
            };
        }
        return this;
    }

    @Override
    public TaskState getState() {
        return this._state;
    }

    @Override
    public Throwable getException() {
        return this._exception;
    }

    protected void checkForValidState(String action) {
        if (this._state == TaskState.EXECUTING) {
            throw new IllegalStateException("Cannot " + action + " a already running task");
        }
        if (this._state == TaskState.CANCELED) {
            throw new IllegalStateException("Cannot " + action + " a task that has been canceled");
        }
        if (this._state == TaskState.ERRORED || this._state == TaskState.SUCCEEDED) {
            throw new IllegalStateException("Cannot " + action + " a task that has already run.");
        }
    }

    protected void onResultSucceeded(T result) {
        if (this._onSuccess != null || this._onComplete != null) {
            this._executor.postback(() -> {
                this._state = TaskState.SUCCEEDED;
                if (this._onSuccess != null) {
                    this._onSuccess.accept(result);
                }
                if (this._onComplete != null) {
                    this._onComplete.accept(result, true);
                }
            });
        } else {
            this._state = TaskState.SUCCEEDED;
        }
    }

    protected void onResultErrored(Throwable throwable) {
        this._exception = throwable;
        if (this._onError == null && this._onComplete == null) {
            this._state = TaskState.ERRORED;
            throw new TaskException(throwable);
        }
        this._executor.postback(() -> {
            Boolean swallowException;
            this._state = TaskState.ERRORED;
            if (this._onError != null && !(swallowException = this._onError.apply(throwable)).booleanValue()) {
                throw new TaskException(throwable);
            }
            if (this._onComplete != null) {
                this._onComplete.accept(null, false);
            }
        });
    }

    @Override
    public boolean isCanceled() {
        return this._state == TaskState.CANCELED;
    }

    @Override
    public void cancel() {
        this._state = TaskState.CANCELED;
    }
}

