/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.DeferredValueTask;
import com.reborn.tasks.IDeferredValueTask;
import com.reborn.tasks.ITask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.ITaskFactory;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.IValueTask;
import com.reborn.tasks.ThreadFactoryWithStackSize;
import com.reborn.tasks.ValueTask;
import com.reborn.tasks.common.ThrowingConsumer;
import com.reborn.tasks.common.ThrowingFunction;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class TaskFactory
implements ITaskFactory {
    private static final ITaskExecutor _executor = new TaskExecutor();

    @Override
    public ITask create(ThrowingConsumer<ITaskOperator> consumer) {
        return new ValueTask<ThrowingFunction<ITaskOperator, Object>>(op -> {
            consumer.accept((ITaskOperator)op);
            return null;
        }, _executor);
    }

    @Override
    public <T> IValueTask<T> create(ThrowingFunction<ITaskOperator, T> function) {
        return new ValueTask<ThrowingFunction<ITaskOperator, T>>(function, _executor);
    }

    @Override
    public <T> IValueTask<T> fromResult(T result) {
        return new ValueTask<T>(result, _executor);
    }

    @Override
    public <T> IDeferredValueTask<T> createDeferred(Consumer<IDeferredValueTask<T>> consumer) {
        return new DeferredValueTask<T>(consumer, _executor);
    }

    public static class TaskExecutor
    implements ITaskExecutor {
        private static final Executor _executor = Executors.newSingleThreadExecutor(new ThreadFactoryWithStackSize(0x7D0000));

        @Override
        public void runTask(Runnable task) {
            _executor.execute(task);
        }

        @Override
        public void postback(Runnable postback) {
            postback.run();
        }
    }
}

