/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.ITask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.TaskState;
import java.util.function.Consumer;

public class TaskOperator
implements ITaskOperator {
    private final Consumer<Object> _onUpdate;
    private final ITask _resultTask;
    private final ITaskExecutor _executor;

    public TaskOperator(Consumer<Object> onUpdate, ITask resultTask, ITaskExecutor executor) {
        this._onUpdate = onUpdate;
        this._resultTask = resultTask;
        this._executor = executor;
    }

    @Override
    public void update(Object update) {
        if (this._onUpdate == null) {
            return;
        }
        this.post(() -> this._onUpdate.accept(update));
    }

    protected void post(Runnable update) {
        this._executor.postback(update);
    }

    @Override
    public boolean isCanceled() {
        return this._resultTask.getState() == TaskState.CANCELED;
    }
}

