/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.IDeferredValueTask;
import com.reborn.tasks.ITask;
import com.reborn.tasks.ITaskFactory;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.IValueTask;
import com.reborn.tasks.TaskFactory;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.ThrowingConsumer;
import com.reborn.tasks.exceptions.CompoundTaskException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Tasks {
    private static ITaskFactory _factory;
    private static Supplier<ITaskFactory> _factorySupplier;

    public static void setTaskFactory(Supplier<ITaskFactory> factorySupplier) {
        _factorySupplier = factorySupplier;
        _factory = null;
    }

    public static void setTaskFactory(ITaskFactory factory) {
        _factorySupplier = null;
        _factory = factory;
    }

    public static ITaskFactory getTaskFactory() {
        if (_factory != null) {
            return _factory;
        }
        if (_factorySupplier != null) {
            _factory = _factorySupplier.get();
            return _factory;
        }
        try {
            Class<?> clazz = Class.forName("android.os.Looper");
        }
        catch (ClassNotFoundException e) {
            _factory = new TaskFactory();
            return _factory;
        }
        try {
            Object instance = Class.forName("com.reborn.tasks.android.AndroidTaskFactory").newInstance();
            _factory = (ITaskFactory)instance;
            return _factory;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("java-tasks-android is needed to run tasks on the android platform", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Something went wrong when trying to create the TaskFactory", e);
        }
    }

    public static ITask create(ThrowingConsumer<ITaskOperator> consumer) {
        return Tasks.getTaskFactory().create(consumer);
    }

    public static <T> IValueTask<T> fromResult(T result) {
        return Tasks.getTaskFactory().fromResult(result);
    }

    public static <T> IDeferredValueTask<T> createDeferred(Consumer<IDeferredValueTask<T>> consumer) {
        return Tasks.getTaskFactory().createDeferred(consumer);
    }

    public static IValueTask<ITask[]> executeAll(ITask ... tasks) {
        return Tasks.createDeferred(def -> {
            for (ITask task : tasks) {
                task.onComplete(() -> {
                    if (Arrays.stream(tasks).allMatch(x -> x.getState() == TaskState.SUCCEEDED)) {
                        def.setSucceeded(tasks);
                    } else if (Arrays.stream(tasks).allMatch(x -> x.getState() == TaskState.SUCCEEDED || x.getState() == TaskState.ERRORED)) {
                        List<Throwable> throwables = Arrays.stream(tasks).filter(x -> x.getState() == TaskState.ERRORED).map(ITask::getException).collect(Collectors.toList());
                        def.setErrored(new CompoundTaskException(throwables));
                    }
                }).onError(x -> true).execute();
            }
        });
    }

    public static <TIn, TOut> IValueTask<TOut> then(IValueTask<TIn> runningTask, Function<TIn, TOut> converter) {
        return Tasks.createDeferred(task -> runningTask.onSuccess(valueIn -> task.setSucceeded(converter.apply(valueIn))).onError(e -> {
            task.setErrored((Throwable)e);
            return true;
        }).execute());
    }
}

