/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.BaseTask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.TaskOperator;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.ICancelable;
import com.reborn.tasks.common.ThrowingFunction;
import java.util.function.Consumer;

public class ValueTask<T>
extends BaseTask<T> {
    private final ITaskExecutor _taskExecutor;
    private T _result;
    private boolean _resultSet;
    private ThrowingFunction<ITaskOperator, T> _callable;

    public ValueTask(ThrowingFunction<ITaskOperator, T> callable, ITaskExecutor taskExecutor) {
        super(taskExecutor);
        this._callable = callable;
        this._taskExecutor = taskExecutor;
    }

    public ValueTask(T result, ITaskExecutor taskExecutor) {
        super(taskExecutor);
        this.checkForValidState("set result on");
        this._result = result;
        this._resultSet = true;
        this._taskExecutor = taskExecutor;
    }

    protected ITaskOperator createTaskOperator(Consumer<Object> onUpdate) {
        return new TaskOperator(onUpdate, this, this._taskExecutor);
    }

    @Override
    public T getResult() {
        if (this._resultSet) {
            return this._result;
        }
        this.execute();
        return this._result;
    }

    @Override
    public ICancelable execute() {
        this.checkForValidState("execute");
        this._state = TaskState.EXECUTING;
        if (this._resultSet) {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            this.onResultSucceeded(this._result);
        } else {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            this._taskExecutor.runTask(this::runOnThread);
        }
        return this;
    }

    private void runOnThread() {
        try {
            ITaskOperator taskOperator = this.createTaskOperator(this._onUpdate);
            this._result = this._callable.apply(taskOperator);
            this._resultSet = true;
            this.onResultSucceeded(this._result);
        }
        catch (Exception e) {
            this.onResultErrored(e);
        }
    }
}

