/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.ICancelable;
import com.reborn.tasks.common.Pair;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ITask
extends ICancelable {
    default public ICancelable execute() {
        return this.execute(null);
    }

    public ICancelable execute(ITaskExecutor var1);

    public TaskState getState();

    public Throwable getException();

    public ITask onExecute(Runnable var1);

    public ITask onSuccess(Runnable var1);

    public ITask onUpdate(Consumer<Object> var1);

    default public ITask onUpdate(BiConsumer<Float, String> onUpdate) {
        return this.onUpdate((Object o) -> {
            Pair pair;
            if (o instanceof Pair) {
                pair = (Pair)o;
                if (!(pair.first instanceof Float) || !(pair.second instanceof String)) {
                    String firstName = pair.first.getClass().getSimpleName();
                    String secondName = pair.second.getClass().getSimpleName();
                    throw new IllegalStateException("update object was a Pair<" + firstName + ", " + secondName + "> and not of type Pair<Float, String>");
                }
            } else {
                String simpleName = o.getClass().getSimpleName();
                throw new IllegalStateException("update object was a " + simpleName + " and not of type Pair<Float, String>");
            }
            onUpdate.accept((Float)pair.first, (String)pair.second);
        });
    }

    public ITask onComplete(Consumer<Boolean> var1);

    default public ITask onComplete(Runnable onComplete) {
        return this.onComplete((Boolean r) -> onComplete.run());
    }

    public ITask onError(Function<Throwable, Boolean> var1);

    default public ITask onError(Consumer<Throwable> onError) {
        return this.onError((Throwable t) -> {
            onError.accept((Throwable)t);
            return true;
        });
    }
}

