/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.IDeferredTask;
import com.reborn.tasks.IDeferredValueTask;
import com.reborn.tasks.ITask;
import com.reborn.tasks.ITaskFactory;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.IValueTask;
import com.reborn.tasks.TaskExecutor;
import com.reborn.tasks.TaskFactory;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.Cancel;
import com.reborn.tasks.common.CompoundCancelable;
import com.reborn.tasks.common.ICancelable;
import com.reborn.tasks.common.ThrowingConsumer;
import com.reborn.tasks.common.ThrowingFunction;
import com.reborn.tasks.exceptions.CompoundTaskException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Tasks {
    private static ITaskFactory _factory;
    private static Supplier<ITaskFactory> _factorySupplier;

    public static void setTaskFactory(Supplier<ITaskFactory> factorySupplier) {
        _factorySupplier = factorySupplier;
        _factory = null;
    }

    public static void setTaskFactory(ITaskFactory factory) {
        _factorySupplier = null;
        _factory = factory;
    }

    public static ITaskFactory getTaskFactory() {
        if (_factory != null) {
            return _factory;
        }
        if (_factorySupplier != null) {
            _factory = _factorySupplier.get();
            return _factory;
        }
        try {
            Class<?> clazz = Class.forName("android.os.Looper");
        }
        catch (ClassNotFoundException e) {
            _factory = new TaskFactory(TaskExecutor.getSingleton());
            return _factory;
        }
        try {
            Object instance = Class.forName("com.reborn.tasks.android.AndroidTaskFactory").newInstance();
            _factory = (ITaskFactory)instance;
            return _factory;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("android-tasks is needed to run tasks on the android platform.\r\nVisit https://github.com/DevReborn/android-tasks for more information", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Something went wrong when trying to create the TaskFactory", e);
        }
    }

    public static ITask create(ThrowingConsumer<ITaskOperator> consumer) {
        return Tasks.getTaskFactory().create(consumer);
    }

    public static <T> IValueTask<T> create(ThrowingFunction<ITaskOperator, T> consumer) {
        return Tasks.getTaskFactory().create(consumer);
    }

    public static <T> IValueTask<T> fromResult(T result) {
        return Tasks.getTaskFactory().fromResult(result);
    }

    public static <T> IDeferredValueTask<T> deferredValue(Function<IDeferredValueTask<T>, ICancelable> function) {
        return Tasks.getTaskFactory().createDeferred(function);
    }

    public static <T> IDeferredValueTask<T> deferredValue(Consumer<IDeferredValueTask<T>> function) {
        return Tasks.deferredValue((IDeferredValueTask<T> t) -> {
            function.accept((IDeferredValueTask)t);
            return Cancel.empty;
        });
    }

    public static IDeferredTask deferred(Function<IDeferredTask, ICancelable> function) {
        return Tasks.getTaskFactory().createDeferred(function::apply);
    }

    public static IDeferredTask deferred(Consumer<IDeferredTask> function) {
        return Tasks.deferred((IDeferredTask t) -> {
            function.accept((IDeferredTask)t);
            return Cancel.empty;
        });
    }

    public static IValueTask<ITask[]> executeAll(ITask ... tasks) {
        return Tasks.deferredValue((IDeferredValueTask<T> def) -> {
            CompoundCancelable cancelable = new CompoundCancelable(new ICancelable[0]);
            for (ITask task : tasks) {
                ICancelable taskCancelable = task.onComplete(() -> {
                    if (Arrays.stream(tasks).allMatch(x -> x.getState() == TaskState.SUCCEEDED)) {
                        def.setSucceeded(tasks);
                    } else if (Arrays.stream(tasks).allMatch(x -> x.getState() == TaskState.SUCCEEDED || x.getState() == TaskState.ERRORED)) {
                        List<Throwable> throwables = Arrays.stream(tasks).filter(x -> x.getState() == TaskState.ERRORED).map(ITask::getException).collect(Collectors.toList());
                        def.setErrored(new CompoundTaskException(throwables));
                    }
                }).onError(x -> true).execute();
                cancelable.add(taskCancelable);
            }
            return cancelable;
        });
    }

    public static <TIn, TOut> IValueTask<TOut> then(IValueTask<TIn> runningTask, Function<TIn, TOut> converter) {
        return Tasks.deferredValue((IDeferredValueTask<T> task) -> runningTask.onSuccess(valueIn -> task.setSucceeded(converter.apply(valueIn))).onError(e -> {
            task.setErrored((Throwable)e);
            return true;
        }).execute());
    }
}

