/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.BaseTask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.ITaskOperator;
import com.reborn.tasks.TaskOperator;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.ICancelable;
import com.reborn.tasks.common.ThrowingFunction;

public class ValueTask<T>
extends BaseTask<T> {
    private final ITaskExecutor _taskExecutor;
    private ThrowingFunction<ITaskOperator, T> _callable;

    public ValueTask(ThrowingFunction<ITaskOperator, T> callable, ITaskExecutor taskExecutor) {
        this._callable = callable;
        this._taskExecutor = taskExecutor;
    }

    public ValueTask(T result, ITaskExecutor taskExecutor) {
        this.checkForValidState("set result on");
        this._result = result;
        this._resultSet = true;
        this._taskExecutor = taskExecutor;
    }

    @Override
    public ICancelable execute(ITaskExecutor executor) {
        this.checkForValidState("execute");
        ITaskExecutor executorToUse = executor == null ? this._taskExecutor : executor;
        this._state = TaskState.EXECUTING;
        if (this._resultSet) {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            this.onResultSucceeded(this._result, executorToUse);
        } else {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            executorToUse.runTask(() -> this.runOnThread(executorToUse));
        }
        return this;
    }

    private void runOnThread(ITaskExecutor executor) {
        try {
            TaskOperator taskOperator = new TaskOperator(this._onUpdate, this, executor);
            this._result = this._callable.apply(taskOperator);
            this._resultSet = true;
            this.onResultSucceeded(this._result, executor);
        }
        catch (Exception e) {
            this.onResultErrored(e, executor);
        }
    }
}

