/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.model.factories.asm;

import java.util.Map;
import org.brijframework.factories.impl.AbstractFactory;
import org.brijframework.group.Group;
import org.brijframework.model.ModelResource;
import org.brijframework.model.factories.ModelResourceFactory;
import org.brijframework.util.printer.LoggerConsole;

public abstract class AbstractModelResourceFactory<K, T extends ModelResource<?>>
extends AbstractFactory<K, T>
implements ModelResourceFactory<K, T> {
    public AbstractModelResourceFactory<K, T> clear() {
        if (this.getCache() != null) {
            this.getCache().clear();
        }
        return this;
    }

    public void loadContainer(K key, T metaInfo) {
        if (this.getContainer() == null) {
            return;
        }
        Group group = this.getContainer().load((Object)metaInfo.getName());
        if (!group.containsKey(key)) {
            group.add(key, metaInfo);
        } else {
            group.update(key, metaInfo);
        }
    }

    public T getContainer(K modelKey) {
        if (this.getContainer() == null) {
            return null;
        }
        return (T)((ModelResource)this.getContainer().find(modelKey));
    }

    public T getMetaInfo(K id) {
        for (Map.Entry entry : this.getCache().entrySet()) {
            if (!entry.getKey().equals(id)) continue;
            return (T)((ModelResource)entry.getValue());
        }
        return (T)this.getContainer((Object)id);
    }

    public void register(T value) {
        String key = value.getId();
        this.register(key, value);
    }

    protected void preregister(K key, T value) {
        LoggerConsole.screen((String)"Resource", (String)("Registering for meta data with id : " + key));
    }

    protected void postregister(K key, T value) {
        LoggerConsole.screen((String)"Resource", (String)("Registered for meta data with id : " + key));
    }
}

