/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.model.factories.resource.impl;

import java.lang.reflect.Field;
import java.util.Map;
import org.brijframework.Access;
import org.brijframework.model.factories.resource.asm.AbstractTypeModelResourceFactory;
import org.brijframework.model.resource.ConstructorModelResource;
import org.brijframework.model.resource.ParameterModelResource;
import org.brijframework.model.resource.PropertyModelResource;
import org.brijframework.model.resource.TypeModelResource;
import org.brijframework.model.resource.asm.AbstractPropertyModelResource;
import org.brijframework.model.resource.impl.ConstructorModelResourceImpl;
import org.brijframework.model.resource.impl.ParameterModelResourceImpl;
import org.brijframework.model.resource.impl.PropertyModelResourceImpl;
import org.brijframework.model.resource.impl.RelationPropertyModelResourceImpl;
import org.brijframework.model.resource.impl.TypeModelResourceImpl;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.model.Model;
import org.brijframework.support.model.ModelConstruct;
import org.brijframework.support.model.ModelParam;
import org.brijframework.support.model.Models;
import org.brijframework.support.model.properties.ModelProperty;
import org.brijframework.support.model.properties.ModelRelation;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.text.StringUtil;

@OrderOn(value=1)
public class AnnotationTypeModelResourceFactory
extends AbstractTypeModelResourceFactory<String, TypeModelResource> {
    private static AnnotationTypeModelResourceFactory factory;

    private AnnotationTypeModelResourceFactory() {
    }

    @SingletonFactory
    public static AnnotationTypeModelResourceFactory getFactory() {
        if (factory == null) {
            factory = new AnnotationTypeModelResourceFactory();
        }
        return factory;
    }

    public AnnotationTypeModelResourceFactory loadFactory() {
        ReflectionFactory.getFactory().getInternalClassList().forEach(target -> {
            if (target.isAnnotationPresent(Models.class) || target.isAnnotationPresent(Model.class)) {
                this.register((Class<?>)target);
            }
        });
        return this;
    }

    @Override
    public void register(Class<?> target) {
        if (target.isAnnotationPresent(Models.class)) {
            Models models = target.getAnnotation(Models.class);
            for (Model metaSetup : models.value()) {
                this.register(target, metaSetup);
            }
        }
        if (target.isAnnotationPresent(Model.class)) {
            Model metaSetup = target.getAnnotation(Model.class);
            this.register(target, metaSetup);
        }
    }

    public void register(Class<?> target, Model model) {
        AbstractPropertyModelResource propertyModelResource;
        Field field;
        TypeModelResourceImpl typeModelResource = (TypeModelResourceImpl)InstanceUtil.getInstance(TypeModelResourceImpl.class, (Object[])new Object[0]);
        typeModelResource.setId(StringUtil.isEmpty((String)model.id()) || "DEFAULT".equalsIgnoreCase(model.id()) ? target.getSimpleName() : model.id());
        typeModelResource.setType(target.getName());
        typeModelResource.setName(StringUtil.isEmpty((String)model.name()) || "DEFAULT".equalsIgnoreCase(model.name()) ? target.getSimpleName() : model.name());
        typeModelResource.setAccess(model.access() != null ? model.access().toString() : Access.AUTO.toString());
        typeModelResource.setConstructor(this.createConstructor(typeModelResource, model.constructor()));
        Map fieldMap = FieldUtil.getAllFieldMap(target, (ReflectionAccess)ReflectionAccess.PRIVATE);
        if (model.properties() != null) {
            for (ModelProperty modelProperty : model.properties()) {
                field = (Field)fieldMap.get(modelProperty.name());
                if (field == null) continue;
                propertyModelResource = this.getPropertyModelResource(target, field, modelProperty);
                typeModelResource.getProperties().put(propertyModelResource.getId(), propertyModelResource);
            }
        }
        if (model.relations() != null) {
            for (ModelRelation modelRelation : model.relations()) {
                field = (Field)fieldMap.get(modelRelation.name());
                if (field == null) continue;
                propertyModelResource = this.getPropertyModelResource(target, field, modelRelation);
                typeModelResource.getProperties().put(propertyModelResource.getId(), propertyModelResource);
            }
        }
        for (Map.Entry entry : fieldMap.entrySet()) {
            String id = (String)entry.getKey();
            Field field2 = (Field)entry.getValue();
            if (field2.isAnnotationPresent(ModelProperty.class)) {
                typeModelResource.getProperties().put(id, this.getPropertyModelResource(target, field2, field2.getAnnotation(ModelProperty.class)));
                continue;
            }
            if (field2.isAnnotationPresent(ModelRelation.class)) {
                typeModelResource.getProperties().put(id, this.getPropertyModelResource(target, field2, field2.getAnnotation(ModelRelation.class)));
                continue;
            }
            typeModelResource.getProperties().put(id, this.getPropertyModelResource(target, field2));
        }
        this.register(typeModelResource);
    }

    private PropertyModelResource<?> getPropertyModelResource(Class<?> target, Field field) {
        PropertyModelResourceImpl propertyResource = new PropertyModelResourceImpl();
        propertyResource.setId(field.getName());
        propertyResource.setType(field.getType().getName());
        propertyResource.setName(field.getName());
        propertyResource.setAccess(Access.AUTO.toString());
        return propertyResource;
    }

    private ConstructorModelResource<?> createConstructor(TypeModelResource typeModelResource, ModelConstruct constructor) {
        ConstructorModelResourceImpl constructorModelResource = new ConstructorModelResourceImpl();
        constructorModelResource.setAccess(constructor.access().toString());
        constructorModelResource.setId(StringUtil.isEmpty((String)constructor.id()) || "DEFAULT".equalsIgnoreCase(constructor.id()) ? typeModelResource.getId() : constructor.id());
        constructorModelResource.setName(StringUtil.isEmpty((String)constructor.name()) || "DEFAULT".equalsIgnoreCase(constructor.name()) ? typeModelResource.getName() : constructor.name());
        if (constructor.params() != null) {
            for (ModelParam modelParam : constructor.params()) {
                constructorModelResource.getParameterList().add(this.getModelParam(modelParam));
            }
        }
        return constructorModelResource;
    }

    private ParameterModelResource getModelParam(ModelParam modelParam) {
        ParameterModelResourceImpl parameterModelResource = new ParameterModelResourceImpl();
        parameterModelResource.setId(modelParam.name());
        parameterModelResource.setIndex(modelParam.index());
        Assertion.notNull((Object)modelParam.type(), (String)"Parameter type is required.");
        parameterModelResource.setType(modelParam.type().getName());
        parameterModelResource.setAccess(Access.AUTO.toString());
        return parameterModelResource;
    }

    private PropertyModelResourceImpl getPropertyModelResource(Class<?> target, Field field, ModelProperty property) {
        PropertyModelResourceImpl propertyResource = new PropertyModelResourceImpl();
        propertyResource.setId(StringUtil.isEmpty((String)property.id()) || "DEFAULT".equalsIgnoreCase(property.id()) ? field.getName() : property.id());
        propertyResource.setType(field.getType().getName());
        propertyResource.setName(StringUtil.isEmpty((String)property.name()) || "DEFAULT".equalsIgnoreCase(property.name()) ? field.getName() : property.name());
        propertyResource.setAccess(property.access() != null ? property.access().toString() : Access.AUTO.toString());
        propertyResource.setRequired(property.required());
        return propertyResource;
    }

    private RelationPropertyModelResourceImpl getPropertyModelResource(Class<?> target, Field field, ModelRelation property) {
        RelationPropertyModelResourceImpl propertyResource = new RelationPropertyModelResourceImpl();
        propertyResource.setId(StringUtil.isEmpty((String)property.id()) || "DEFAULT".equalsIgnoreCase(property.id()) ? field.getName() : property.id());
        propertyResource.setType(field.getType().getName());
        propertyResource.setName(StringUtil.isEmpty((String)property.name()) || "DEFAULT".equalsIgnoreCase(property.name()) ? field.getName() : property.name());
        propertyResource.setAccess(property.access() != null ? property.access().toString() : Access.AUTO.toString());
        propertyResource.setRequired(property.required());
        propertyResource.setMappedBy(property.mappedBy());
        return propertyResource;
    }
}

