/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.util.WatchConfig;

public class WatchRunable
implements Runnable {
    private WatchConfig config;
    private ConcurrentHashMap<String, Long> updated = new ConcurrentHashMap();

    public WatchRunable(WatchConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        if (this.config == null) {
            return;
        }
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(this.config.getDir().toURI());
            dir.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE);
            this.watching(this.config, watcher);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void watching(WatchConfig config, WatchService watcher) {
        try {
            WatchKey key = watcher.take();
            List<WatchEvent<?>> pollEvents = key.pollEvents();
            for (WatchEvent<?> event : pollEvents) {
                Long lastModified;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path fileName = (Path)ev.context();
                File file = fileName.toFile();
                File ctPath = new File(config.getDir().getPath(), file.getName());
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_CREATE || !ctPath.exists() || (lastModified = this.updated.get(ctPath.getAbsolutePath())) != null && lastModified.longValue() == ctPath.lastModified()) continue;
                this.updated.put(ctPath.getAbsolutePath(), ctPath.lastModified());
                config.recall(ctPath);
            }
            pollEvents.clear();
            boolean valid = key.reset();
            if (valid) {
                this.watching(config, watcher);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}

