/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.LogicUnit;

public abstract class AnnotationUtil {
    public static Annotation getAnnotation(Class<?> _class, Class _annotation) {
        Annotation annotation = null;
        if (_class != null) {
            annotation = (Annotation)_class.getAnnotation(_annotation);
        }
        return annotation;
    }

    public static Annotation getAnnotation(AccessibleObject _field, Class _annotation) {
        Annotation annotation = null;
        if (_field != null) {
            annotation = (Annotation)_field.getAnnotation(_annotation);
        }
        return annotation;
    }

    public static boolean isExistAnnotation(Class<?> _class, Class _annotation) {
        Object annotation = null;
        if (_class != null) {
            annotation = _class.getAnnotation(_annotation);
        }
        return annotation != null;
    }

    public static boolean isExistAnnotation(Field _field, Class _annotation) {
        Object annotation = null;
        if (_field != null) {
            annotation = _field.getAnnotation(_annotation);
        }
        return annotation != null;
    }

    public static boolean isExistAnnotation(Method _method, Class _annotation) {
        Object annotation = null;
        if (_method != null) {
            annotation = _method.getAnnotation(_annotation);
        }
        return annotation != null;
    }

    public static Field getAnnotationField(Class<?> _class, Class _annotation) {
        List<Field> fields = FieldUtil.getAllField(_class);
        for (Field field : fields) {
            if (AnnotationUtil.getAnnotation(field, _annotation) == null) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getAnnotationFields(Class<?> _class, Class<?> _annotaion) {
        List<Field> fields = FieldUtil.getAllField(_class);
        ArrayList<Field> fieldReturn = new ArrayList<Field>();
        for (Field field : fields) {
            if (AnnotationUtil.getAnnotation(field, _annotaion) == null) continue;
            fieldReturn.add(field);
        }
        return fieldReturn;
    }

    public static Annotation[] getAnnotations(Class<?> _class) {
        return _class.getAnnotations();
    }

    public static Annotation[] getAnnotations(Method _method) {
        return _method.getAnnotations();
    }

    public static Annotation[] getAnnotations(Field _Field) {
        return _Field.getAnnotations();
    }

    public static Map<String, Object> getAnnotationData(Class<?> _class, Class<?> _annotation) {
        Method[] methods;
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        Annotation annotation = AnnotationUtil.getAnnotation(_class, _annotation);
        if (annotation == null) {
            return _returnMap;
        }
        for (Method method : methods = annotation.annotationType().getMethods()) {
            try {
                if (!method.getDeclaringClass().equals(annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Map<String, Object> getAnnotationData(Constructor<?> _class, Class<?> _annotation) {
        Method[] methods;
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        Annotation annotation = AnnotationUtil.getAnnotation(_class, _annotation);
        if (annotation == null) {
            return _returnMap;
        }
        for (Method method : methods = annotation.annotationType().getMethods()) {
            try {
                if (!method.getDeclaringClass().equals(annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Map<String, Object> getAnnotationData(Parameter _class, Class<? extends Annotation> _annotation) {
        Method[] methods;
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        Annotation annotation = AnnotationUtil.getAnnotation(_class, _annotation);
        if (annotation == null) {
            return _returnMap;
        }
        for (Method method : methods = annotation.annotationType().getMethods()) {
            try {
                if (!method.getDeclaringClass().equals(annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Annotation getAnnotation(Parameter _class, Class<? extends Annotation> _annotation) {
        if (_class == null) {
            return null;
        }
        return _class.getAnnotation(_annotation);
    }

    public static Map<String, Object> getAnnotationDataForField(Field _field, Class<?> _annotation) {
        Method[] methods;
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        Annotation annotation = AnnotationUtil.getAnnotation(_field, _annotation);
        if (annotation == null) {
            return _returnMap;
        }
        for (Method method : methods = annotation.annotationType().getMethods()) {
            try {
                if (!method.getDeclaringClass().equals(annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Map<String, Object> getAnnotationDataForMethod(Method _method, Class<?> _annotation) {
        Method[] methods;
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        Annotation annotation = AnnotationUtil.getAnnotation(_method, _annotation);
        if (annotation == null) {
            return _returnMap;
        }
        for (Method method : methods = annotation.annotationType().getMethods()) {
            try {
                if (!method.getDeclaringClass().equals(annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Map<String, Object> getAnnotationData(Annotation _annotation) {
        Method[] methods = _annotation.annotationType().getMethods();
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        for (Method method : methods) {
            try {
                if (!method.getDeclaringClass().equals(_annotation.annotationType())) continue;
                _returnMap.put(method.getName(), method.invoke((Object)_annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return _returnMap;
    }

    public static Map<String, Object> getAnnotionData(Object _object, Class<?> _annotation) {
        if (_object instanceof Method) {
            return AnnotationUtil.getAnnotationDataForMethod((Method)_object, _annotation);
        }
        if (_object instanceof Field) {
            return AnnotationUtil.getAnnotationDataForField((Field)_object, _annotation);
        }
        if (_object instanceof Class) {
            return AnnotationUtil.getAnnotationData((Class)_object, _annotation);
        }
        return null;
    }

    public static Annotation getAnnotation(Class<?> _class, Class<?> _annotation, String target, String key, String value) {
        Annotation annotation = AnnotationUtil.getAnnotation(_class, _annotation);
        if (annotation == null) {
            return null;
        }
        for (Method method : annotation.annotationType().getMethods()) {
            Annotation[] annotations;
            if (!target.equals(method.getName())) continue;
            for (Annotation ann : annotations = (Annotation[])LogicUnit.callMethod((Object)annotation, method, new Object[0])) {
                for (Method meth : ann.annotationType().getMethods()) {
                    Object val;
                    if (!meth.getName().equals(key) || (val = LogicUnit.callMethod((Object)ann, method, new Object[0])) == null || !val.equals(value)) continue;
                    return ann;
                }
            }
        }
        return null;
    }

    public static Map<String, Object> getAnnotationData(AccessibleObject target, Class<?> _annotation) {
        if (target instanceof Method) {
            return AnnotationUtil.getAnnotationDataForMethod((Method)target, _annotation);
        }
        if (target instanceof Field) {
            return AnnotationUtil.getAnnotationDataForField((Field)target, _annotation);
        }
        return null;
    }
}

