/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererException;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.lineutility;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.clsUtility;
import RenderMultipoints.clsUtilityCPOF;
import RenderMultipoints.clsUtilityGE;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

public final class clsClipQuad {
    private static final String _className = "clsClipQuad";

    private static int AddBoundaryPointsForLines(ArrayList<Point2D> polygon, ArrayList<Point2D> clipBounds) {
        int result = 0;
        try {
            Point2D pt02d = polygon.get(0);
            Point2D ptLast2d = polygon.get(polygon.size() - 1);
            POINT2 pt0 = new POINT2(pt02d.getX(), pt02d.getY());
            POINT2 ptLast = new POINT2(ptLast2d.getX(), ptLast2d.getY());
            Point2D.Double nearestPt = new Point2D.Double();
            Polygon clipArray = new Polygon();
            int j = 0;
            double minDist = Double.MAX_VALUE;
            double dist = 0.0;
            POINT2 sidePt = new POINT2();
            Boolean addToFront = false;
            Boolean addToEnd = false;
            for (j = 0; j < clipBounds.size(); ++j) {
                clipArray.addPoint((int)clipBounds.get(j).getX(), (int)clipBounds.get(j).getY());
            }
            double totalX = 0.0;
            double totalY = 0.0;
            int counter = 0;
            for (j = 0; j < clipBounds.size() - 1; ++j) {
                totalX += clipBounds.get(j).getX();
                totalY += clipBounds.get(j).getY();
                ++counter;
            }
            if (clipBounds.get(0).getX() != clipBounds.get(j).getX() || clipBounds.get(0).getY() != clipBounds.get(j).getY()) {
                totalX += clipBounds.get(j).getX();
                totalY += clipBounds.get(j).getY();
                ++counter;
            }
            double avgX = totalX / (double)counter;
            double avgY = totalY / (double)counter;
            POINT2 ptCenter = new POINT2(avgX, avgY);
            POINT2 ptNear = null;
            if (!clipArray.contains(pt02d)) {
                for (j = 0; j < clipBounds.size(); ++j) {
                    sidePt.x = clipBounds.get(j).getX();
                    sidePt.y = clipBounds.get(j).getY();
                    dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)sidePt);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    ((Point2D)nearestPt).setLocation(sidePt.x, sidePt.y);
                }
                ptNear = new POINT2(((Point2D)nearestPt).getX(), ((Point2D)nearestPt).getY());
                ptNear = lineutility.ExtendAlongLineDouble((POINT2)ptNear, (POINT2)ptCenter, (double)2.0);
                ((Point2D)nearestPt).setLocation(ptNear.x, ptNear.y);
                polygon.add(0, nearestPt);
                addToFront = true;
            }
            nearestPt = new Point2D.Double();
            minDist = Double.MAX_VALUE;
            if (!clipArray.contains(ptLast2d)) {
                for (j = 0; j < clipBounds.size(); ++j) {
                    sidePt.x = clipBounds.get(j).getX();
                    sidePt.y = clipBounds.get(j).getY();
                    dist = lineutility.CalcDistanceDouble((POINT2)ptLast, (POINT2)sidePt);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    ((Point2D)nearestPt).setLocation(sidePt.x, sidePt.y);
                }
                ptNear = new POINT2(((Point2D)nearestPt).getX(), ((Point2D)nearestPt).getY());
                ptNear = lineutility.ExtendAlongLineDouble((POINT2)ptNear, (POINT2)ptCenter, (double)2.0);
                ((Point2D)nearestPt).setLocation(ptNear.x, ptNear.y);
                polygon.add(nearestPt);
                addToEnd = true;
            }
            if (!addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 0;
            } else if (addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 1;
            } else if (!addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 2;
            } else if (addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 3;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"AddBoundaryPointsForLines", (Exception)new RendererException("Failed inside AddBoundaryPointsForLines", (Throwable)exc));
        }
        return result;
    }

    private static int AddBoundaryPointsForLines(ArrayList<Point2D> polygon, Rectangle2D clipBounds) {
        int result = 0;
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lrx = 0.0;
            double lry = 0.0;
            ulx = clipBounds.getMinX();
            uly = clipBounds.getMinY();
            lrx = clipBounds.getMaxX();
            lry = clipBounds.getMaxY();
            Point2D.Double ul = new Point2D.Double(ulx + 10.0, uly + 10.0);
            Point2D.Double lr = new Point2D.Double(lrx - 10.0, lry - 10.0);
            Point2D pt0 = polygon.get(0);
            Point2D ptn = polygon.get(polygon.size() - 1);
            Boolean addToFront = false;
            Boolean addToEnd = false;
            if (pt0.getY() < uly) {
                polygon.add(0, ul);
                addToFront = true;
            } else if (pt0.getX() < ulx) {
                polygon.add(0, ul);
                addToFront = true;
            } else if (pt0.getX() > lrx) {
                polygon.add(0, lr);
                addToFront = true;
            } else if (pt0.getY() > lry) {
                polygon.add(0, lr);
                addToFront = true;
            }
            if (ptn.getY() < uly) {
                polygon.add(ul);
                addToEnd = true;
            } else if (ptn.getX() < ulx) {
                polygon.add(ul);
                addToEnd = true;
            } else if (ptn.getX() > lrx) {
                polygon.add(lr);
                addToEnd = true;
            } else if (ptn.getY() > lry) {
                polygon.add(lr);
                addToEnd = true;
            }
            if (!addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 0;
            }
            if (addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 1;
            }
            if (!addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 2;
            }
            if (addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 3;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"AddBoundaryPointsForLines", (Exception)new RendererException("Failed inside AddBoundaryPointsForLines", (Throwable)exc));
        }
        return result;
    }

    private static Point2D CalcTrueIntersectDouble(double m1, double b1, double m2, double b2, int bolVertical1, int bolVertical2, double X1, double X2) {
        Point2D.Double ptIntersect = new Point2D.Double(X1, X2);
        try {
            double x = 0.0;
            double y = 0.0;
            if (bolVertical1 == 0 && bolVertical2 == 0) {
                return ptIntersect;
            }
            if (bolVertical1 == 0 && bolVertical2 == 1) {
                ((Point2D)ptIntersect).setLocation(X1, m2 * X1 + b2);
                return ptIntersect;
            }
            if (bolVertical1 == 1 && bolVertical2 == 0) {
                ((Point2D)ptIntersect).setLocation(X2, m1 * X2 + b1);
                return ptIntersect;
            }
            if (m1 != m2) {
                x = (b2 - b1) / (m1 - m2);
                y = m1 * x + b1;
                ((Point2D)ptIntersect).setLocation(x, y);
                return ptIntersect;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CalcTrueIntersectDouble", (Exception)new RendererException("Failed inside CalcTrueIntersectDouble", (Throwable)exc));
        }
        return ptIntersect;
    }

    private static Point2D intersectPoint2(Point2D previous, Point2D current, Line2D currentEdge) {
        Point2D ptIntersect = null;
        try {
            Point2D ll = currentEdge.getP1();
            Point2D ul = currentEdge.getP2();
            if (Math.abs(current.getX() - previous.getX()) < 1.0) {
                current.setLocation(current.getX() + 1.0, current.getY());
            }
            double m1 = (ul.getY() - ll.getY()) / (ul.getX() - ll.getX());
            double m2 = (current.getY() - previous.getY()) / (current.getX() - previous.getX());
            double b1 = ul.getY() - m1 * ul.getX();
            double b2 = current.getY() - m2 * current.getX();
            ptIntersect = clsClipQuad.CalcTrueIntersectDouble(m1, b1, m2, b2, 1, 1, 0.0, 0.0);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"intersectPoint2", (Exception)new RendererException("Failed inside intersectPoint2", (Throwable)exc));
        }
        return ptIntersect;
    }

    private static ArrayList<Point2D> clipSide(TGLight tg, ArrayList<Point2D> pts, int index, ArrayList<Point2D> clipBounds) {
        ArrayList<Point2D> ptsResult = null;
        try {
            Point2D.Double pt1 = new Point2D.Double(clipBounds.get(index).getX(), clipBounds.get(index).getY());
            Point2D.Double pt2 = new Point2D.Double(clipBounds.get(index + 1).getX(), clipBounds.get(index + 1).getY());
            Point2D.Double clipBoundsPoint = null;
            Point2D ptClipBoundsIntersect = null;
            double m1 = 0.0;
            double m2 = 0.0;
            double b1 = 0.0;
            double b2 = 0.0;
            double b3 = 0.0;
            double b4 = 0.0;
            Point2D ptPreviousIntersect = null;
            Point2D ptCurrentIntersect = null;
            int j = 0;
            int clipBoundsQuadrant = -1;
            int previousQuadrant = -1;
            int currentQuadrant = -1;
            Point2D current = null;
            Point2D previous = null;
            Point2D intersectPt = null;
            ptsResult = new ArrayList<Point2D>();
            if (index == 0) {
                clipBoundsPoint = new Point2D.Double(clipBounds.get(index + 2).getX(), clipBounds.get(index + 2).getY());
            } else if (index > 1) {
                clipBoundsPoint = new Point2D.Double(clipBounds.get(index - 2).getX(), clipBounds.get(index - 2).getY());
            } else if (index == 1) {
                clipBoundsPoint = new Point2D.Double(clipBounds.get(0).getX(), clipBounds.get(0).getY());
            }
            if (Math.abs(((Point2D)pt2).getX() - ((Point2D)pt1).getX()) < 1.0) {
                ((Point2D)pt2).setLocation(((Point2D)pt2).getX() + 1.0, ((Point2D)pt2).getY());
            }
            if (Math.abs(((Point2D)pt2).getY() - ((Point2D)pt1).getY()) < 1.0) {
                ((Point2D)pt2).setLocation(((Point2D)pt2).getX(), ((Point2D)pt2).getY() + 1.0);
            }
            for (j = 0; j < pts.size(); ++j) {
                Line2D.Double edge;
                current = pts.get(j);
                previous = j == 0 ? pts.get(pts.size() - 1) : pts.get(j - 1);
                m1 = (((Point2D)pt2).getY() - ((Point2D)pt1).getY()) / (((Point2D)pt2).getX() - ((Point2D)pt1).getX());
                m2 = -1.0 / m1;
                b1 = ((Point2D)pt2).getY() - m1 * ((Point2D)pt2).getX();
                b2 = previous.getY() - m2 * previous.getX();
                b3 = current.getY() - m2 * current.getX();
                b4 = ((Point2D)clipBoundsPoint).getY() - m2 * ((Point2D)clipBoundsPoint).getX();
                ptPreviousIntersect = clsClipQuad.CalcTrueIntersectDouble(m1, b1, m2, b2, 1, 1, 0.0, 0.0);
                ptCurrentIntersect = clsClipQuad.CalcTrueIntersectDouble(m1, b1, m2, b3, 1, 1, 0.0, 0.0);
                ptClipBoundsIntersect = clsClipQuad.CalcTrueIntersectDouble(m1, b1, m2, b4, 1, 1, 0.0, 0.0);
                clipBoundsQuadrant = lineutility.GetQuadrantDouble((double)((Point2D)clipBoundsPoint).getX(), (double)((Point2D)clipBoundsPoint).getY(), (double)ptClipBoundsIntersect.getX(), (double)ptClipBoundsIntersect.getY());
                previousQuadrant = lineutility.GetQuadrantDouble((double)previous.getX(), (double)previous.getY(), (double)ptPreviousIntersect.getX(), (double)ptPreviousIntersect.getY());
                currentQuadrant = lineutility.GetQuadrantDouble((double)current.getX(), (double)current.getY(), (double)ptCurrentIntersect.getX(), (double)ptCurrentIntersect.getY());
                if (previousQuadrant == clipBoundsQuadrant && currentQuadrant == clipBoundsQuadrant) {
                    ptsResult.add(current);
                    continue;
                }
                if (previousQuadrant == clipBoundsQuadrant && currentQuadrant != clipBoundsQuadrant) {
                    edge = new Line2D.Double(pt1, pt2);
                    intersectPt = clsClipQuad.intersectPoint2(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    tg.set_WasClipped(true);
                    continue;
                }
                if (previousQuadrant != clipBoundsQuadrant && currentQuadrant == clipBoundsQuadrant) {
                    edge = new Line2D.Double(pt1, pt2);
                    intersectPt = clsClipQuad.intersectPoint2(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    ptsResult.add(current);
                    tg.set_WasClipped(true);
                    continue;
                }
                if (previousQuadrant != clipBoundsQuadrant && currentQuadrant == clipBoundsQuadrant) continue;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"clipSide", (Exception)new RendererException("Failed inside clipSide", (Throwable)exc));
        }
        return ptsResult;
    }

    protected static void addAbatisFill(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            if (tg.Pixels == null || tg.Pixels.size() < 2 || tg.get_FillColor() == null || tg.get_FillColor().getAlpha() < 2 || shapes == null) {
                return;
            }
            int j = 0;
            int n = tg.Pixels.size();
            Shape2 shape = null;
            TGLight tg2 = null;
            switch (tg.get_LineType()) {
                case 23410000: {
                    double dist0 = 0.0;
                    double dist1 = 0.0;
                    double dist2 = 0.0;
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.setFillColor(tg.get_FillColor());
                    if (!(tg.Pixels != null & tg.Pixels.size() >= 300)) break;
                    dist0 = Math.abs(((POINT2)tg.Pixels.get((int)0)).x - ((POINT2)tg.Pixels.get((int)50)).x);
                    dist1 = Math.abs(((POINT2)tg.Pixels.get((int)100)).x - ((POINT2)tg.Pixels.get((int)150)).x);
                    dist2 = Math.abs(((POINT2)tg.Pixels.get((int)200)).x - ((POINT2)tg.Pixels.get((int)250)).x);
                    int start = -1;
                    int end = -1;
                    if (dist0 >= dist1 && dist0 >= dist2) {
                        start = 0;
                        end = 99;
                    } else if (dist1 >= dist0 && dist1 >= dist2) {
                        start = 100;
                        end = 199;
                    } else {
                        start = 200;
                        end = 299;
                    }
                    shape.moveTo((POINT2)tg.Pixels.get(start));
                    for (j = start; j <= end; ++j) {
                        shape.lineTo((POINT2)tg.Pixels.get(j));
                    }
                    break;
                }
                case 23120000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.setFillColor(tg.get_FillColor());
                    tg2 = new TGLight();
                    tg2.set_LineType(22131000);
                    tg2.Pixels = new ArrayList();
                    if (tg.Pixels == null || tg.Pixels.size() <= 2) break;
                    tg2.Pixels.add(tg.Pixels.get(n - 3));
                    tg2.Pixels.add(tg.Pixels.get(n - 2));
                    tg2.Pixels.add(tg.Pixels.get(n - 1));
                    tg2.Pixels.add(tg.Pixels.get(n - 3));
                    shape.moveTo((POINT2)tg2.Pixels.get(0));
                    for (j = 1; j < tg2.Pixels.size(); ++j) {
                        shape.lineTo((POINT2)tg2.Pixels.get(j));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (shapes != null) {
                shapes.add(0, shape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"addAbatisFill", (Exception)new RendererException("Failed inside addAbatisFill", (Throwable)exc));
        }
    }

    protected static ArrayList<Shape2> LinesWithFill(TGLight tg, ArrayList<Point2D> clipBounds) {
        ArrayList<Shape2> shapes = null;
        try {
            if (tg.get_FillColor() == null || tg.get_FillColor().getAlpha() <= 1 || tg.Pixels == null || tg.Pixels.isEmpty()) {
                return shapes;
            }
            switch (tg.get_LineType()) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23120000: 
                case 25211000: 
                case 25212000: 
                case 211400000: 
                case 211600000: 
                case 211900000: 
                case 212100000: 
                case 212500000: 
                case 212600000: {
                    return shapes;
                }
                case 24326100: {
                    return null;
                }
                case 22134000: 
                case 22340000: 
                case 22350000: 
                case 22624000: 
                case 23111000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131200: 
                case 23132000: 
                case 23350000: {
                    return clsClipQuad.fillDMA(tg, clipBounds);
                }
            }
            if (!clsUtility.LinesWithFill((int)tg.get_LineType())) {
                return shapes;
            }
            shapes = new ArrayList<Shape2>();
            Shape2 shape = null;
            TGLight tg2 = new TGLight();
            tg2.set_LineType(22131000);
            tg2.Pixels = new ArrayList();
            tg2.Pixels.addAll(tg.Pixels);
            clsClipQuad.closeAreaTG(tg2);
            if (clipBounds != null) {
                clsClipQuad.ClipPolygon(tg2, clipBounds);
            }
            if (tg2.Pixels == null || tg2.Pixels.isEmpty()) {
                return null;
            }
            int j = 0;
            shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            shape.setFillColor(tg.get_FillColor());
            shape.moveTo((POINT2)tg2.Pixels.get(0));
            for (j = 1; j < tg2.Pixels.size(); ++j) {
                shape.lineTo((POINT2)tg2.Pixels.get(j));
            }
            if (tg.get_FillColor() == null && tg.get_FillColor().getAlpha() <= 1) {
                return null;
            }
            shapes.add(shape);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"LinesWithFill", (Exception)new RendererException("Failed inside LinesWithFill", (Throwable)exc));
        }
        return shapes;
    }

    private static void closeAreaTG(TGLight tg) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            POINT2 pt0 = (POINT2)tg.Pixels.get(0);
            POINT2 ptn = (POINT2)tg.Pixels.get(tg.Pixels.size() - 1);
            if (pt0.x != ptn.x || pt0.y != ptn.y) {
                tg.Pixels.add(pt0);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"closeAreaTG", (Exception)new RendererException("Failed inside closeAreaTG", (Throwable)exc));
        }
    }

    protected static ArrayList<Shape2> fillDMA(TGLight tg, ArrayList<Point2D> clipBounds) {
        ArrayList<Shape2> shapes = new ArrayList<Shape2>();
        try {
            switch (tg.get_LineType()) {
                case 22134000: 
                case 22340000: 
                case 22350000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131200: 
                case 23132000: 
                case 23350000: {
                    break;
                }
                default: {
                    return shapes;
                }
            }
            Shape2 shape = null;
            int j = 0;
            TGLight tg2 = new TGLight();
            tg2.set_LineType(22131000);
            tg2.Pixels = new ArrayList();
            int n = 0;
            n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                tg2.Pixels.add(tg.Pixels.get(j));
            }
            clsClipQuad.closeAreaTG(tg2);
            if (clipBounds != null) {
                clsClipQuad.ClipPolygon(tg2, clipBounds);
            }
            if (tg2.Pixels == null || tg2.Pixels.isEmpty()) {
                return shapes;
            }
            shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            shape.setFillColor(tg.get_FillColor());
            shape.moveTo((POINT2)tg2.Pixels.get(0));
            for (j = 1; j < tg2.Pixels.size(); ++j) {
                shape.lineTo((POINT2)tg2.Pixels.get(j));
            }
            shapes.add(shape);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"fillDMA", (Exception)new RendererException("Failed inside fillDMA", (Throwable)exc));
        }
        return shapes;
    }

    protected static ArrayList<Point2D> ClipPolygon(TGLight tg, ArrayList<Point2D> clipBounds) {
        ArrayList<Point2D> poly = new ArrayList<Point2D>();
        try {
            Boolean isClosed = clsUtility.isClosedPolygon((int)tg.get_LineType());
            clipBounds = clsUtilityGE.expandPolygon(clipBounds, 20.0);
            ArrayList<Point2D> polygon = clsUtilityCPOF.POINT2toPoint2D(tg.Pixels);
            int j = 0;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (j = 0; j < polygon.size(); ++j) {
                hashMap.put(Integer.toString(j), polygon.get(j));
            }
            Point2D clipBoundsPtStart = clipBounds.get(0);
            Point2D clipBoundsPtEnd = clipBounds.get(clipBounds.size() - 1);
            if (clipBoundsPtStart.getX() != clipBoundsPtEnd.getX() || clipBoundsPtStart.getY() != clipBoundsPtEnd.getY()) {
                clipBounds.add(clipBoundsPtStart);
            }
            int addedLinePoints = 0;
            if (isClosed.booleanValue()) {
                polygon.remove(polygon.size() - 1);
            } else {
                addedLinePoints = clsClipQuad.AddBoundaryPointsForLines(polygon, clipBounds);
            }
            for (j = 0; j < clipBounds.size() - 1; ++j) {
                poly = j == 0 ? clsClipQuad.clipSide(tg, polygon, j, clipBounds) : clsClipQuad.clipSide(tg, poly, j, clipBounds);
            }
            if (isClosed.booleanValue()) {
                if (poly.size() > 0) {
                    poly.add(poly.get(0));
                }
            } else {
                switch (addedLinePoints) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(0);
                        break;
                    }
                    case 2: {
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                        break;
                    }
                    case 3: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                    }
                }
            }
            tg.Pixels = isClosed.booleanValue() ? (poly.size() > 2 ? clsUtilityCPOF.Point2DtoPOINT2Mapped(poly, hashMap) : new ArrayList()) : (poly.size() > 1 ? clsUtilityCPOF.Point2DtoPOINT2Mapped(poly, hashMap) : new ArrayList());
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ClipPolygon", (Exception)new RendererException("Failed inside ClipPolygon", (Throwable)exc));
        }
        return poly;
    }
}

