/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.FileHandler;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SymbolDefTable {
    private static SymbolDefTable _instance = null;
    private static Map<String, SymbolDef> _SymbolDefinitionsB = null;
    private static ArrayList<SymbolDef> _SymbolDefDupsB = null;
    private static Map<String, SymbolDef> _SymbolDefinitionsC = null;
    private static ArrayList<SymbolDef> _SymbolDefDupsC = null;
    private static String propSymbolID = "SYMBOLID";
    private static String propGeometry = "GEOMETRY";
    private static String propDrawCategory = "DRAWCATEGORY";
    private static String propMaxPoint = "MAXPOINTS";
    private static String propMinPoints = "MINPOINTS";
    private static String propHasWidth = "HASWIDTH";
    private static String propModifiers = "MODIFIERS";
    private static String propDescription = "DESCRIPTION";
    private static String propHierarchy = "HIERARCHY";

    private SymbolDefTable() {
        this.Init();
    }

    public static synchronized SymbolDefTable getInstance() {
        if (_instance == null) {
            _instance = new SymbolDefTable();
        }
        return _instance;
    }

    private void Init() {
        _SymbolDefinitionsB = new HashMap<String, SymbolDef>();
        _SymbolDefDupsB = new ArrayList();
        _SymbolDefinitionsC = new HashMap<String, SymbolDef>();
        _SymbolDefDupsC = new ArrayList();
        String xmlPathB = "XML/SymbolConstantsB.xml";
        String xmlPathC = "XML/SymbolConstantsC.xml";
        InputStream xmlStreamB = this.getClass().getClassLoader().getResourceAsStream(xmlPathB);
        String lookupXmlB = FileHandler.InputStreamToString(xmlStreamB);
        InputStream xmlStreamC = this.getClass().getClassLoader().getResourceAsStream(xmlPathC);
        String lookupXmlC = FileHandler.InputStreamToString(xmlStreamC);
        this.populateLookup(lookupXmlB, 0);
        this.populateLookup(lookupXmlC, 1);
    }

    private void populateLookup(String xml, int symStd) {
        SymbolDef sd = null;
        ArrayList<String> al = XMLUtil.getItemList(xml, "<SYMBOL>", "</SYMBOL>");
        for (int i = 0; i < al.size(); ++i) {
            String data = al.get(i);
            String symbolID = XMLUtil.parseTagValue(data, "<SYMBOLID>", "</SYMBOLID>");
            String geometry = XMLUtil.parseTagValue(data, "<GEOMETRY>", "</GEOMETRY>");
            String drawCategory = XMLUtil.parseTagValue(data, "<DRAWCATEGORY>", "</DRAWCATEGORY>");
            String maxpoints = XMLUtil.parseTagValue(data, "<MAXPOINTS>", "</MAXPOINTS>");
            String minpoints = XMLUtil.parseTagValue(data, "<MINPOINTS>", "</MINPOINTS>");
            String modifiers = XMLUtil.parseTagValue(data, "<MODIFIERS>", "</MODIFIERS>");
            String description = XMLUtil.parseTagValue(data, "<DESCRIPTION>", "</DESCRIPTION>");
            description = description.replaceAll("&amp;", "&");
            String hierarchy = XMLUtil.parseTagValue(data, "<HIERARCHY>", "</HIERARCHY>");
            String path = XMLUtil.parseTagValue(data, "<PATH>", "</PATH>");
            sd = new SymbolDef();
            sd.setBasicSymbolId(symbolID);
            sd.setDescription(description);
            sd.setDrawCategory(Integer.valueOf(drawCategory));
            sd.setHierarchy(hierarchy);
            sd.setGeometry(geometry);
            sd.setMinPoints(Integer.valueOf(minpoints));
            sd.setMaxPoints(Integer.valueOf(maxpoints));
            sd.setModifiers(modifiers);
            sd.setFullPath(path);
            boolean isMCSSpecific = SymbolUtilities.isMCSSpecificTacticalGraphic(sd);
            if (symStd == 0) {
                if (!_SymbolDefinitionsB.containsKey(symbolID) && !isMCSSpecific) {
                    _SymbolDefinitionsB.put(symbolID, sd);
                    continue;
                }
                if (isMCSSpecific) continue;
                _SymbolDefDupsB.add(sd);
                continue;
            }
            if (symStd != 1) continue;
            if (!_SymbolDefinitionsC.containsKey(symbolID) && !isMCSSpecific) {
                _SymbolDefinitionsC.put(symbolID, sd);
                continue;
            }
            if (isMCSSpecific) continue;
            _SymbolDefDupsC.add(sd);
        }
    }

    public SymbolDef getSymbolDef(String basicSymbolID, int symStd) {
        SymbolDef returnVal = null;
        if (symStd == 0) {
            returnVal = _SymbolDefinitionsB.get(basicSymbolID);
        } else if (symStd == 1) {
            returnVal = _SymbolDefinitionsC.get(basicSymbolID);
        }
        return returnVal;
    }

    public Map<String, SymbolDef> GetAllSymbolDefs(int symStd) {
        if (symStd == 0) {
            return _SymbolDefinitionsB;
        }
        if (symStd == 1) {
            return _SymbolDefinitionsC;
        }
        return null;
    }

    public ArrayList GetAllSymbolDefDups(int symStd) {
        if (symStd == 0) {
            return _SymbolDefDupsB;
        }
        if (symStd == 1) {
            return _SymbolDefDupsC;
        }
        return null;
    }

    public Boolean HasSymbolDef(String basicSymbolID, int symStd) {
        if (basicSymbolID != null && basicSymbolID.length() == 15) {
            if (symStd == 0) {
                return _SymbolDefinitionsB.containsKey(basicSymbolID);
            }
            if (symStd == 1) {
                return _SymbolDefinitionsC.containsKey(basicSymbolID);
            }
            return false;
        }
        return false;
    }

    public Boolean isMultiPoint(String symbolID, int symStd) {
        char codingScheme = symbolID.charAt(0);
        Boolean returnVal = false;
        if (codingScheme == 'G' || codingScheme == 'W') {
            String basicSymbolID = symbolID.charAt(1) != '*' ? SymbolUtilities.getBasicSymbolID(symbolID) : symbolID;
            SymbolDef sd = this.getSymbolDef(basicSymbolID, symStd);
            if (sd != null) {
                if (sd.getMaxPoints() > 1) {
                    returnVal = true;
                } else {
                    switch (sd.getDrawCategory()) {
                        case 5: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: {
                            returnVal = true;
                            break;
                        }
                        default: {
                            returnVal = false;
                        }
                    }
                }
                return returnVal;
            }
            return false;
        }
        if (symbolID.startsWith("BS_") || symbolID.startsWith("BBS_") || symbolID.startsWith("PBS_")) {
            return true;
        }
        return false;
    }
}

