/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Utilities;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SymbolDraw {
    public static void Draw(MilStdSymbol symbol, Graphics2D destination, int offsetX, int offsetY) throws RendererException {
        ArrayList<MilStdSymbol> symbols = new ArrayList<MilStdSymbol>();
        symbols.add(symbol);
        SymbolDraw.Draw(symbols, destination, offsetX, offsetY);
    }

    public static void Draw(ArrayList<MilStdSymbol> symbols, Graphics2D destination, int offsetX, int offsetY) throws RendererException {
        Logger loggy = Logger.getLogger("SECRenderer ErrorLogger");
        try {
            AffineTransform oldTransform;
            Stroke oldStroke;
            if (symbols != null && destination != null) {
                destination.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                oldStroke = destination.getStroke();
                oldTransform = destination.getTransform();
                int unitCount = symbols.size();
                for (int lcv = 0; lcv < unitCount; ++lcv) {
                    Point2D point;
                    AffineTransform atTemp;
                    ShapeInfo siTemp;
                    int i;
                    MilStdSymbol symbol = symbols.get(lcv);
                    ArrayList<ShapeInfo> shapes = symbol.getSymbolShapes();
                    if (shapes == null) continue;
                    for (i = 0; i < shapes.size(); ++i) {
                        siTemp = shapes.get(i);
                        if (siTemp.getAffineTransform() != null) {
                            atTemp = (AffineTransform)siTemp.getAffineTransform().clone();
                            atTemp.preConcatenate(AffineTransform.getTranslateInstance(offsetX, offsetY));
                            destination.setTransform(atTemp);
                        } else {
                            destination.translate(offsetX, offsetY);
                        }
                        if (siTemp.getStroke() != null) {
                            destination.setStroke(siTemp.getStroke());
                        }
                        if (siTemp.getTexturePaint() != null) {
                            TexturePaint tp = siTemp.getTexturePaint();
                            destination.setPaint(tp);
                            destination.fill(siTemp.getShape());
                        } else if (siTemp.getFillColor() != null) {
                            destination.setColor(siTemp.getFillColor());
                            if (siTemp.getShape() != null) {
                                destination.fill(siTemp.getShape());
                            }
                        }
                        if (siTemp.getLineColor() != null) {
                            destination.setColor(siTemp.getLineColor());
                            point = null;
                            if (siTemp.getShape() != null) {
                                destination.draw(siTemp.getShape());
                            } else if (siTemp.getGlyphVector() != null) {
                                point = siTemp.getGlyphPosition();
                                destination.drawGlyphVector(siTemp.getGlyphVector(), (float)point.getX(), (float)point.getY());
                            } else if (siTemp.getTextLayout() != null) {
                                point = siTemp.getGlyphPosition();
                                siTemp.getTextLayout().draw(destination, (float)point.getX(), (float)point.getY());
                            }
                        }
                        destination.setTransform(oldTransform);
                        destination.setStroke(oldStroke);
                    }
                    shapes = symbol.getModifierShapes();
                    if (shapes == null) continue;
                    for (i = 0; i < shapes.size(); ++i) {
                        siTemp = shapes.get(i);
                        if (siTemp.getAffineTransform() != null) {
                            atTemp = (AffineTransform)siTemp.getAffineTransform().clone();
                            atTemp.preConcatenate(AffineTransform.getTranslateInstance(offsetX, offsetY));
                            destination.setTransform(atTemp);
                        } else {
                            destination.translate(offsetX, offsetY);
                        }
                        if (siTemp.getStroke() != null) {
                            destination.setStroke(siTemp.getStroke());
                        }
                        if (siTemp.getFillColor() != null) {
                            destination.setColor(siTemp.getFillColor());
                            if (siTemp.getShape() != null) {
                                destination.fill(siTemp.getShape());
                            } else {
                                siTemp.setLineColor(siTemp.getFillColor());
                                siTemp.setFillColor(null);
                            }
                        }
                        if (siTemp.getLineColor() != null) {
                            destination.setColor(siTemp.getLineColor());
                            point = null;
                            if (siTemp.getShape() != null) {
                                destination.draw(siTemp.getShape());
                            } else if (siTemp.getGlyphVector() != null) {
                                point = siTemp.getGlyphPosition();
                                destination.drawGlyphVector(siTemp.getGlyphVector(), (float)point.getX(), (float)point.getY());
                            } else if (siTemp.getTextLayout() != null) {
                                point = siTemp.getGlyphPosition();
                                siTemp.getTextLayout().draw(destination, (float)point.getX(), (float)point.getY());
                            }
                        }
                        destination.setTransform(oldTransform);
                    }
                }
            } else {
                String badValues = "Bad parameters passed: ";
                if (symbols == null) {
                    badValues = badValues + " symbols";
                }
                if (destination == null) {
                    badValues = badValues + " destination";
                }
                RendererException re = new RendererException(badValues, null);
                loggy.logp(Level.INFO, "SymbolDraw", "Draw()", "draw failure", re);
                throw re;
            }
            destination.setTransform(oldTransform);
            destination.setStroke(oldStroke);
        }
        catch (Exception exc) {
            RendererException re2 = new RendererException("Draw Operation Failed", exc);
            loggy.logp(Level.INFO, "SymbolDraw", "Draw()", "draw failure", re2);
            throw re2;
        }
    }

    public static ArrayList<ShapeInfo> ProcessModifierBackgrounds(ArrayList<ShapeInfo> modifiers) {
        ArrayList<ShapeInfo> alTemp = modifiers;
        ArrayList<ShapeInfo> modifierShapes = new ArrayList<ShapeInfo>();
        ShapeInfo temp = null;
        ShapeInfo outline = null;
        ShapeInfo background = null;
        if (alTemp != null) {
            int tempSize = alTemp.size();
            for (int i = 0; i < tempSize; ++i) {
                ArrayList<ShapeInfo> outlines;
                temp = alTemp.get(i);
                if (temp == null) continue;
                if (RendererSettings.getInstance().getTextBackgroundMethod() == 1) {
                    background = SymbolDraw.createTextBackgroundFill(temp);
                    if (background != null) {
                        modifierShapes.add(background);
                    }
                } else if (RendererSettings.getInstance().getTextBackgroundMethod() == 2) {
                    outline = SymbolDraw.createTextOutline(temp);
                    if (outline != null) {
                        modifierShapes.add(outline);
                    }
                } else if (RendererSettings.getInstance().getTextBackgroundMethod() == 3 && (outlines = SymbolDraw.createTextOutlineQuick(temp)) != null) {
                    modifierShapes.addAll(outlines);
                }
                modifierShapes.add(temp);
            }
        }
        return modifierShapes;
    }

    public static ShapeInfo createTextOutline(ShapeInfo originalText) {
        return SymbolDraw.createTextOutline(originalText, RendererSettings.getInstance().getTextOutlineWidth());
    }

    public static ShapeInfo createTextOutline(ShapeInfo originalText, int outlineSize) {
        Shape outline = null;
        ShapeInfo siOutline = null;
        outlineSize = Math.abs(outlineSize);
        Color textColor = null;
        try {
            if (originalText.getShape() != null) {
                outline = new GeneralPath(originalText.getShape());
            } else if (originalText.getTextLayout() != null) {
                outline = originalText.getTextLayout().getOutline(AffineTransform.getTranslateInstance(originalText.getGlyphPosition().getX(), originalText.getGlyphPosition().getY()));
            }
            siOutline = new ShapeInfo(outline);
            if (originalText.getFillColor() != null) {
                textColor = originalText.getFillColor();
            } else if (originalText.getLineColor() != null) {
                textColor = originalText.getLineColor();
            }
            if (originalText.getAffineTransform() != null) {
                siOutline.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
            }
            if (originalText.getTextBackgroundColor() != null) {
                siOutline.setLineColor(originalText.getTextBackgroundColor());
            } else {
                siOutline.setLineColor(SymbolDraw.getIdealTextBackgroundColor(textColor));
            }
            siOutline.setStroke(new BasicStroke(outlineSize, 1, 1, 3.0f));
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "createTextOuline", exc);
        }
        return siOutline;
    }

    public static ArrayList<ShapeInfo> createTextOutlineQuick(ShapeInfo originalText) {
        int thickness = RendererSettings.getInstance().getTextOutlineWidth();
        return SymbolDraw.createTextOutlineQuick(originalText, thickness);
    }

    public static ArrayList<ShapeInfo> createTextOutlineQuick(ShapeInfo originalText, int thickness) {
        ShapeInfo siOutline1 = null;
        ShapeInfo siOutline2 = null;
        ShapeInfo siOutline3 = null;
        ShapeInfo siOutline4 = null;
        AffineTransform afx1 = null;
        AffineTransform afx2 = null;
        AffineTransform afx3 = null;
        AffineTransform afx4 = null;
        ArrayList<ShapeInfo> outlineShapes = null;
        Color textColor = null;
        Color backgroundColor = null;
        try {
            int offset = 0;
            if (originalText.getTextLayout() != null) {
                textColor = originalText.getLineColor();
                backgroundColor = originalText.getTextBackgroundColor() != null ? originalText.getTextBackgroundColor() : SymbolDraw.getIdealTextBackgroundColor(textColor);
                outlineShapes = new ArrayList<ShapeInfo>();
                for (int i = 1; i <= thickness; ++i) {
                    offset = i;
                    Point2D.Double textPosition = null;
                    textPosition = originalText.getModifierStringPosition() != null ? new Point2D.Double(originalText.getModifierStringPosition().getX(), originalText.getModifierStringPosition().getY()) : new Point2D.Double(0.0, 0.0);
                    if (i % 2 != 0) {
                        siOutline1 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                        siOutline2 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                        siOutline3 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                        siOutline4 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    } else {
                        siOutline1 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY()));
                        siOutline2 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY()));
                        siOutline3 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() + (double)offset));
                        siOutline4 = new ShapeInfo(originalText.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() - (double)offset));
                    }
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    if (originalText.getAffineTransform() != null) {
                        siOutline1.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline2.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline3.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline4.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                    }
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                }
            } else if (originalText.getGlyphVector() != null) {
                textColor = originalText.getLineColor();
                backgroundColor = SymbolDraw.getIdealTextBackgroundColor(textColor);
                outlineShapes = new ArrayList();
                for (int j = 1; j <= thickness; ++j) {
                    offset = j;
                    Point2D.Double textPosition = new Point2D.Double(originalText.getGlyphPosition().getX(), originalText.getGlyphPosition().getY());
                    if (j % 2 != 0) {
                        siOutline1 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                        siOutline2 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                        siOutline3 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                        siOutline4 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    } else {
                        siOutline1 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY()));
                        siOutline2 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY()));
                        siOutline3 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() + (double)offset));
                        siOutline4 = new ShapeInfo(originalText.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() - (double)offset));
                    }
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    if (originalText.getAffineTransform() != null) {
                        siOutline1.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline2.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline3.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                        siOutline4.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
                    }
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                }
            } else if (originalText.getShape() != null) {
                textColor = originalText.getLineColor();
                backgroundColor = SymbolDraw.getIdealTextBackgroundColor(textColor);
                outlineShapes = new ArrayList();
                for (int k = 1; k <= thickness; ++k) {
                    offset = k;
                    siOutline1 = new ShapeInfo(originalText.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline2 = new ShapeInfo(originalText.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline3 = new ShapeInfo(originalText.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline4 = new ShapeInfo(originalText.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    if (originalText.getAffineTransform() == null) {
                        afx1 = new AffineTransform();
                        afx2 = new AffineTransform();
                        afx3 = new AffineTransform();
                        afx4 = new AffineTransform();
                    } else {
                        afx1 = new AffineTransform(originalText.getAffineTransform());
                        afx2 = new AffineTransform(originalText.getAffineTransform());
                        afx3 = new AffineTransform(originalText.getAffineTransform());
                        afx4 = new AffineTransform(originalText.getAffineTransform());
                    }
                    if (k % 2 != 0) {
                        afx1.translate(-offset, -offset);
                        afx2.translate(offset, -offset);
                        afx3.translate(-offset, offset);
                        afx4.translate(offset, offset);
                    } else {
                        afx1.translate(-offset, 0.0);
                        afx2.translate(offset, 0.0);
                        afx3.translate(0.0, offset);
                        afx4.translate(0.0, -offset);
                    }
                    siOutline1.setAffineTransform(afx1);
                    siOutline2.setAffineTransform(afx2);
                    siOutline3.setAffineTransform(afx3);
                    siOutline4.setAffineTransform(afx4);
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                }
            } else {
                String message = "ShapeInfo wasn't a TextLayout or a GlyphVector, returning null";
                ErrorLogger.LogMessage("SymbolDraw", "createTextOutlineQuick()", message, Level.FINEST);
                return null;
            }
            return outlineShapes;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "createTextOuline", exc);
            return null;
        }
    }

    public static ArrayList<ShapeInfo> createSinglePointOutline(ShapeInfo symbolFrame, int thickness, Color outlineColor) {
        ShapeInfo siOutline1 = null;
        ShapeInfo siOutline2 = null;
        ShapeInfo siOutline3 = null;
        ShapeInfo siOutline4 = null;
        ShapeInfo siOutline5 = null;
        ShapeInfo siOutline6 = null;
        ShapeInfo siOutline7 = null;
        ShapeInfo siOutline8 = null;
        AffineTransform afx1 = null;
        AffineTransform afx2 = null;
        AffineTransform afx3 = null;
        AffineTransform afx4 = null;
        AffineTransform afx5 = null;
        AffineTransform afx6 = null;
        AffineTransform afx7 = null;
        AffineTransform afx8 = null;
        ArrayList<ShapeInfo> outlineShapes = null;
        Color lineColor = null;
        Color backgroundColor = null;
        try {
            int offset = 0;
            backgroundColor = outlineColor == null ? SymbolDraw.getIdealTextBackgroundColor(lineColor) : outlineColor;
            outlineShapes = new ArrayList<ShapeInfo>();
            if (symbolFrame.getTextLayout() != null) {
                outlineShapes = new ArrayList();
                for (int i = 1; i <= thickness; ++i) {
                    offset = i;
                    Point2D.Double textPosition = null;
                    textPosition = symbolFrame.getModifierStringPosition() != null ? new Point2D.Double(symbolFrame.getModifierStringPosition().getX(), symbolFrame.getModifierStringPosition().getY()) : new Point2D.Double(0.0, 0.0);
                    siOutline1 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                    siOutline2 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                    siOutline3 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    siOutline4 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    siOutline5 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY()));
                    siOutline6 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY()));
                    siOutline7 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() + (double)offset));
                    siOutline8 = new ShapeInfo(symbolFrame.getTextLayout(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() - (double)offset));
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    siOutline5.setLineColor(backgroundColor);
                    siOutline6.setLineColor(backgroundColor);
                    siOutline7.setLineColor(backgroundColor);
                    siOutline8.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    siOutline5.setStroke(tempStroke);
                    siOutline6.setStroke(tempStroke);
                    siOutline7.setStroke(tempStroke);
                    siOutline8.setStroke(tempStroke);
                    if (symbolFrame.getAffineTransform() != null) {
                        siOutline1.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline2.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline3.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline4.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline5.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline6.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline7.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline8.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                    }
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                    outlineShapes.add(siOutline5);
                    outlineShapes.add(siOutline6);
                    outlineShapes.add(siOutline7);
                    outlineShapes.add(siOutline8);
                }
            } else if (symbolFrame.getGlyphVector() != null) {
                outlineShapes = new ArrayList();
                for (int j = 1; j <= thickness; ++j) {
                    offset = j;
                    Point2D.Double textPosition = new Point2D.Double(symbolFrame.getGlyphPosition().getX(), symbolFrame.getGlyphPosition().getY());
                    siOutline1 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                    siOutline2 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() - (double)offset));
                    siOutline3 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    siOutline4 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY() + (double)offset));
                    siOutline5 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() - (double)offset, ((Point2D)textPosition).getY()));
                    siOutline6 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX() + (double)offset, ((Point2D)textPosition).getY()));
                    siOutline7 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() + (double)offset));
                    siOutline8 = new ShapeInfo(symbolFrame.getGlyphVector(), (Point2D)new Point2D.Double(((Point2D)textPosition).getX(), ((Point2D)textPosition).getY() - (double)offset));
                    if (symbolFrame.getShapeType() == ShapeInfo.SHAPE_TYPE_TG_SP_FRAME) {
                        siOutline1.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline2.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline3.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline4.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline5.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline6.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline7.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                        siOutline8.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_OUTLINE);
                    }
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    siOutline5.setLineColor(backgroundColor);
                    siOutline6.setLineColor(backgroundColor);
                    siOutline7.setLineColor(backgroundColor);
                    siOutline8.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    siOutline5.setStroke(tempStroke);
                    siOutline6.setStroke(tempStroke);
                    siOutline7.setStroke(tempStroke);
                    siOutline8.setStroke(tempStroke);
                    if (symbolFrame.getAffineTransform() != null) {
                        siOutline1.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline2.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline3.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline4.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline5.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline6.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline7.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                        siOutline8.setAffineTransform(new AffineTransform(symbolFrame.getAffineTransform()));
                    }
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                    outlineShapes.add(siOutline5);
                    outlineShapes.add(siOutline6);
                    outlineShapes.add(siOutline7);
                    outlineShapes.add(siOutline8);
                }
            } else if (symbolFrame.getShape() != null) {
                outlineShapes = new ArrayList();
                for (int k = 1; k <= thickness; ++k) {
                    offset = k;
                    siOutline1 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline2 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline3 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline4 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline5 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline6 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline7 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline8 = new ShapeInfo(symbolFrame.getShape(), ShapeInfo.SHAPE_TYPE_SINGLE_POINT_OUTLINE);
                    siOutline1.setLineColor(backgroundColor);
                    siOutline2.setLineColor(backgroundColor);
                    siOutline3.setLineColor(backgroundColor);
                    siOutline4.setLineColor(backgroundColor);
                    siOutline5.setLineColor(backgroundColor);
                    siOutline6.setLineColor(backgroundColor);
                    siOutline7.setLineColor(backgroundColor);
                    siOutline8.setLineColor(backgroundColor);
                    BasicStroke tempStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
                    siOutline1.setStroke(tempStroke);
                    siOutline2.setStroke(tempStroke);
                    siOutline3.setStroke(tempStroke);
                    siOutline4.setStroke(tempStroke);
                    siOutline5.setStroke(tempStroke);
                    siOutline6.setStroke(tempStroke);
                    siOutline7.setStroke(tempStroke);
                    siOutline8.setStroke(tempStroke);
                    if (symbolFrame.getAffineTransform() == null) {
                        afx1 = new AffineTransform();
                        afx2 = new AffineTransform();
                        afx3 = new AffineTransform();
                        afx4 = new AffineTransform();
                        afx5 = new AffineTransform();
                        afx6 = new AffineTransform();
                        afx7 = new AffineTransform();
                        afx8 = new AffineTransform();
                    } else {
                        afx1 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx2 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx3 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx4 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx5 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx6 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx7 = new AffineTransform(symbolFrame.getAffineTransform());
                        afx8 = new AffineTransform(symbolFrame.getAffineTransform());
                    }
                    afx1.translate(-offset, -offset);
                    afx2.translate(offset, -offset);
                    afx3.translate(-offset, offset);
                    afx4.translate(offset, offset);
                    afx5.translate(-offset, 0.0);
                    afx6.translate(offset, 0.0);
                    afx7.translate(0.0, offset);
                    afx8.translate(0.0, -offset);
                    siOutline1.setAffineTransform(afx1);
                    siOutline2.setAffineTransform(afx2);
                    siOutline3.setAffineTransform(afx3);
                    siOutline4.setAffineTransform(afx4);
                    siOutline5.setAffineTransform(afx5);
                    siOutline6.setAffineTransform(afx6);
                    siOutline7.setAffineTransform(afx7);
                    siOutline8.setAffineTransform(afx8);
                    outlineShapes.add(siOutline1);
                    outlineShapes.add(siOutline2);
                    outlineShapes.add(siOutline3);
                    outlineShapes.add(siOutline4);
                    outlineShapes.add(siOutline5);
                    outlineShapes.add(siOutline6);
                    outlineShapes.add(siOutline7);
                    outlineShapes.add(siOutline8);
                }
            } else {
                String message = "ShapeInfo wasn't a TextLayout or a GlyphVector, returning null";
                ErrorLogger.LogMessage("SymbolDraw", "createTextOutlineQuick()", message, Level.FINEST);
                return null;
            }
            return outlineShapes;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "createTextOuline", exc);
            return null;
        }
    }

    public static ShapeInfo createTextBackgroundFill(ShapeInfo originalText) {
        Rectangle tempRect = null;
        ShapeInfo background = null;
        ShapeInfo returnVal = null;
        try {
            tempRect = originalText.getTextLayout().getPixelBounds(null, (float)originalText.getGlyphPosition().getX(), (float)originalText.getGlyphPosition().getY());
            background = new ShapeInfo(new Rectangle(tempRect.x - 2, tempRect.y - 2, tempRect.width + 4, tempRect.height + 4));
            if (originalText.getTextBackgroundColor() != null) {
                background.setFillColor(originalText.getTextBackgroundColor());
            } else if (RendererSettings.getInstance().getLabelBackgroundColor() != null) {
                background.setFillColor(RendererSettings.getInstance().getLabelBackgroundColor());
            } else {
                Color bgColor = null;
                bgColor = originalText.getLineColor() != null ? SymbolDraw.getIdealTextBackgroundColor(originalText.getLineColor()) : (originalText.getFillColor() != null ? SymbolDraw.getIdealTextBackgroundColor(originalText.getFillColor()) : Color.white);
                background.setFillColor(bgColor);
            }
            if (originalText.getAffineTransform() != null) {
                background.setAffineTransform(new AffineTransform(originalText.getAffineTransform()));
            }
            returnVal = background;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "CreateTextBackgroundFill", exc);
        }
        return returnVal;
    }

    public static ShapeInfo CreateModifierShapeInfo(TextLayout text, String modifierValue, double x, double y) {
        return SymbolDraw.CreateModifierShapeInfo(text, modifierValue, x, y, Color.BLACK, null);
    }

    public static ShapeInfo CreateModifierShapeInfo(TextLayout text, String modifierValue, double x, double y, Color textColor) {
        return SymbolDraw.CreateModifierShapeInfo(text, modifierValue, x, y, textColor, null);
    }

    public static ShapeInfo CreateModifierShapeInfo(TextLayout text, String modifierValue, double x, double y, Color textColor, Color textBackgroundColor) {
        try {
            ShapeInfo si = new ShapeInfo(text, (Point2D)new Point((int)x, (int)y));
            if (textColor == null) {
                textColor = Color.BLACK;
            }
            int textRenderMethod = RendererSettings.getInstance().getTextRenderMethod();
            AffineTransform at = null;
            if (textRenderMethod == 0) {
                at = new AffineTransform();
                at.translate(x, y);
                Shape label = text.getOutline(at);
                si = new ShapeInfo(label);
                si.setFillColor(textColor);
            } else if (textRenderMethod == 1) {
                si = new ShapeInfo(text, (Point2D)new Point((int)x, (int)y));
                si.setLineColor(textColor);
            }
            si.setModifierString(modifierValue);
            si.setModifierStringPosition(new Point((int)x, (int)y));
            si.setStroke(new BasicStroke(0.0f, 1, 1, 3.0f));
            si.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
            if (textBackgroundColor != null) {
                si.setTextBackgroundColor(textBackgroundColor);
            }
            return si;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("JavaRenderer", "CreateModifierShapeInfo", exc);
            return null;
        }
    }

    public static Color getIdealTextBackgroundColor(Color fgColor) {
        try {
            float[] hsbvals = new float[3];
            if (fgColor != null) {
                int nThreshold = RendererSettings.getInstance().getTextBackgroundAutoColorThreshold();
                int bgDelta = (int)((double)fgColor.getRed() * 0.299 + (double)fgColor.getGreen() * 0.587 + (double)fgColor.getBlue() * 0.114);
                return 255 - bgDelta < nThreshold ? new Color(0, 0, 0, fgColor.getAlpha()) : new Color(255, 255, 255, fgColor.getAlpha());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "getIdealtextBGColor", exc);
        }
        return Color.WHITE;
    }

    public static String ShapeInfosToString(ArrayList<ShapeInfo> shapes) {
        StringBuilder sb = new StringBuilder();
        Shape tempShape = null;
        try {
            for (int i = 0; i < shapes.size(); ++i) {
                tempShape = shapes.get(i).getShape();
                if (tempShape == null || !(tempShape instanceof GeneralPath)) continue;
                sb.append(SymbolDraw.GeneralPathToString((GeneralPath)tempShape));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String GeneralPathToString(GeneralPath path) {
        StringBuilder sb = new StringBuilder();
        PathIterator itr = null;
        double[] coords = new double[6];
        int pathSegmentType = 0;
        String strPathSegmentType = "";
        try {
            itr = path.getPathIterator(null);
            while (!itr.isDone()) {
                pathSegmentType = itr.currentSegment(coords);
                if (pathSegmentType == 0) {
                    sb.append("SEG_MOVETO");
                } else if (pathSegmentType == 3) {
                    sb.append("SEG_CUBICTO");
                } else if (pathSegmentType == 1) {
                    sb.append("SEG_LINETO");
                } else if (pathSegmentType == 2) {
                    sb.append("SEG_QUADTO");
                } else if (pathSegmentType == 4) {
                    sb.append("SEG_CLOSE");
                }
                sb.append(": ");
                if (pathSegmentType == 0) {
                    sb.append(String.valueOf(coords[0]) + ", " + String.valueOf(coords[1]));
                } else if (pathSegmentType == 3) {
                    sb.append(String.valueOf(coords[0]) + ", " + String.valueOf(coords[1]));
                } else if (pathSegmentType == 1) {
                    sb.append(String.valueOf(coords[0]) + ", " + String.valueOf(coords[1]));
                } else if (pathSegmentType == 2) {
                    sb.append(String.valueOf(coords[0]) + ", " + String.valueOf(coords[1]));
                } else if (pathSegmentType == 4) {
                    sb.append(String.valueOf(coords[0]) + ", " + String.valueOf(coords[1]));
                }
                sb.append('\n');
                coords = new double[6];
                itr.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

